#include "stdafx.h"
#include "ArticleSubmitter.h"
#include "ArticlesDlg.h"
#include "ArticleManager.h"
#include "NewArtDlg.h"
#include "EditArticleDlg.h"

// CArticlesDlg dialog
IMPLEMENT_DYNAMIC(CArticlesDlg, CDialog)
CArticlesDlg::CArticlesDlg(CWnd* pParent)
	: CDialog(CArticlesDlg::IDD, pParent)
{
	mSizeInited = 0;
}

CArticlesDlg::~CArticlesDlg()
{
}

void CArticlesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SITELIST, mArticleList);
	DDX_Control(pDX, IDC_DELETE, mDeleteButton);
	DDX_Control(pDX, IDC_ADDART, mNewArtButton);
	DDX_Control(pDX, IDC_EDITART, mEditButton);
}


BEGIN_MESSAGE_MAP(CArticlesDlg, CDialog)
	ON_NOTIFY(HDN_ITEMDBLCLICK, 0, OnHdnItemdblclickSitelist)
	ON_WM_LBUTTONDBLCLK()
	ON_NOTIFY(NM_DBLCLK, IDC_SITELIST, OnNMDblclkSitelist)
	ON_WM_SIZE()
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_SITELIST, OnLvnItemchangedSitelist)
	ON_WM_ERASEBKGND()
	ON_BN_CLICKED(IDC_DELETE, OnBnClickedDelete)
	ON_BN_CLICKED(IDC_ADDART, OnBnClickedAddart)
	ON_BN_CLICKED(IDC_EDITART, OnBnClickedEditart)
END_MESSAGE_MAP()


// CArticlesDlg message handlers

BOOL CArticlesDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	mArticleList.SetExtendedStyle( mArticleList.GetExtendedStyle() | LVS_EX_FULLROWSELECT );
	mArticleList.EnableToolTips(TRUE);

	mArticleList.InsertColumn( 0, _T("Article Name"), LVCFMT_LEFT, 350 );

	std::vector<CArticle*>& articles = theApp.mManager.getArticles();

	int counter = 0;

	for (std::vector<CArticle*>::iterator i = articles.begin();
			i < articles.end(); i++)
	{
		CString title = (*i)->getTitle();
		CString text = (*i)->getText();

		LVITEM item1;
		ZeroMemory( &item1, sizeof( LVITEM ) );
		item1.mask = LVIF_IMAGE|LVIF_PARAM;
		item1.lParam = (DWORD)(*i);
		item1.iImage = 0;
		item1.iItem = 0;

		int id = mArticleList.InsertItem( &item1 );

		mArticleList.SetItemText( id, 0, title );
		mArticleList.SetItemToolTipText( id, 0, title );
		counter++;
	}
	mSizeInited = 1;

	return TRUE;
}

void CArticlesDlg::OnBnClickedAdd()
{
/*
	CNewArticleDlg dlg;
	if (dlg.DoModal() == IDOK)
	{
		CArticle* art = new CArticle();
		art->setTitle( dlg.mTitle );
		art->setText( dlg.mText );
		art->setKeywords( dlg.mKeywords );
		theApp.mManager.addArticle( art );
		theApp.mManager.Save();

		//add to the list view
		LVITEM item1;
		ZeroMemory( &item1, sizeof( LVITEM ) );
		item1.mask = LVIF_IMAGE|LVIF_PARAM;
		item1.lParam = (DWORD)art;
		item1.iImage = 0;
		item1.iItem = 0;
		int id = mArticleList.InsertItem( &item1 );

		mArticleList.SetItemText( id, 0, dlg.mTitle );
//		mArticleList.SetItemToolTipText( id, 0, dlg.mTitle );
	}
*/

}

void CArticlesDlg::OnBnClickedEdit()
{
	int pos = mArticleList.GetSelectionMark();

	if (pos == -1)
		return;

	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.iItem = (UINT)pos;
	item1.mask = LVIF_PARAM;
	mArticleList.GetItem( &item1 );

	CArticle* article = (CArticle*)item1.lParam;

	if (article)
	{
		CEditArticleDlg dlg;
		dlg.mTitle = article->getTitle();
		dlg.mText = article->getText();
		if (dlg.DoModal() == IDOK)
		{
			article->setTitle( dlg.mTitle );
			article->setText( dlg.mText );
			theApp.mManager.Save();
		}
	}
}

void CArticlesDlg::OnHdnItemdblclickSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMHEADER phdr = reinterpret_cast<LPNMHEADER>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	if (phdr->pitem)
	{
		CArticle* article = (CArticle*)phdr->pitem->lParam;
		if (article)
		{
			CEditArticleDlg dlg;
			dlg.mTitle = article->getTitle();
			dlg.mText = article->getText();
			if (dlg.DoModal() == IDOK)
			{
				article->setTitle( dlg.mTitle );
				article->setText( dlg.mText );
				theApp.mManager.Save();
			}
		}
	}
}

void CArticlesDlg::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default

	CDialog::OnLButtonDblClk(nFlags, point);
}

void CArticlesDlg::OnNMDblclkSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{

	if (mArticleList.GetSelectedCount() == 0)
		return;

	OnBnClickedEditart();
}

void CArticlesDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	if (!mSizeInited)
		return;

	RECT r;
	GetWindowRect( &r );
	RECT r3;
	GetClientRect( &r3 );

	int x = 5;
	int y = 5;
	int w = (r.right - r.left) - 10;
	int h = (r.bottom - r.top) - 10;

	mArticleList.MoveWindow( x, y, w, h - 30 );

	RECT r2;
	mDeleteButton.GetClientRect( &r2 );
	int x2 = x;
	int w2 = r2.right - r2.left;
	int h2 = r2.bottom - r2.top;
	int y2 = (y+h)-h2;
	mDeleteButton.MoveWindow( x2, y2, w2, h2 );

	x2 += w2 + 5;
	mEditButton.MoveWindow( x2, y2, w2, h2 );

	x2 += w2 + 5;
	mNewArtButton.MoveWindow( x2, y2, w2+10, h2 );

}

void CArticlesDlg::OnLvnItemchangedSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	*pResult = 0;

	CArticle* article = (CArticle*)pNMLV->lParam;
	if (!article)
		return;

	theApp.SetCurArticle( article );
}

BOOL CArticlesDlg::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default

	RECT r1;
	mArticleList.GetClientRect( &r1 );
	pDC->ExcludeClipRect( &r1 );
	return CDialog::OnEraseBkgnd(pDC);
}

void CArticlesDlg::OnBnClickedDelete()
{
	int pos = mArticleList.GetSelectionMark();

	if (pos == -1)
		return;

	int test = MessageBox( _T("Are you sure you want to delete this article?"), _T("Delete Article"), MB_YESNO );
	if (test != IDYES)
		return;


	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.iItem = (UINT)pos;
	item1.mask = LVIF_PARAM;
	mArticleList.GetItem( &item1 );
	CArticle* article = (CArticle*)item1.lParam;

	mArticleList.DeleteItem( pos );
	theApp.mManager.DeleteArticle( article );
}

void CArticlesDlg::OnBnClickedAddart()
{
	CNewArtDlg dlg;
	if (dlg.DoModal() == IDOK)
	{
		CArticle* art = new CArticle();
		art->setTitle( dlg.mTitle );
		art->setText( dlg.mText );
		art->setSummary( dlg.mSummary );
		theApp.mManager.addArticle( art );
		theApp.mManager.Save();

		//add to the list view
		LVITEM item1;
		ZeroMemory( &item1, sizeof( LVITEM ) );
		item1.mask = LVIF_IMAGE|LVIF_PARAM;
		item1.lParam = (DWORD)art;
		item1.iImage = 0;
		item1.iItem = 0;
		int id = mArticleList.InsertItem( &item1 );

		mArticleList.SetItemText( id, 0, dlg.mTitle );
	}
}

void CArticlesDlg::OnBnClickedEditart()
{
	int pos = mArticleList.GetSelectionMark();

	if (pos == -1)
		return;

	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.iItem = (UINT)pos;
	item1.mask = LVIF_PARAM;
	mArticleList.GetItem( &item1 );
	CArticle* article = (CArticle*)item1.lParam;
	if (!article)
		return;


	CNewArtDlg dlg; 
	dlg.mTitle = article->getTitle();
	dlg.mText = article->getText();
	dlg.mSummary = article->getSummary();
	dlg.mKeywords = article->getKeywords();

	if (dlg.DoModal() == IDOK)
	{
		article->setTitle( dlg.mTitle );
		article->setText( dlg.mText );
		article->setSummary( dlg.mSummary );
		article->setKeywords( dlg.mKeywords );
		theApp.mManager.Save();

		mArticleList.SetItemText( pos, 0, article->getTitle() );
	}
}
