#include "stdafx.h"
#include "ArticleSubmitter.h"
#include "EditSiteDlg.h"
#include "ArticleManager.h"
#include "AdvancedSiteDlg.h"


// CEditSiteDlg dialog

IMPLEMENT_DYNAMIC(CEditSiteDlg, CDialog)
CEditSiteDlg::CEditSiteDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEditSiteDlg::IDD, pParent)
	, mSiteName(_T(""))
	, mURL(_T(""))
	, mRequiresLogin(FALSE)
	, mUsername(_T(""))
	, mPassword(_T(""))
	, mAutoLogin(FALSE)
{
	mSite = 0;
}

CEditSiteDlg::~CEditSiteDlg()
{
}

void CEditSiteDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_SITENAME, mSiteName);
	DDX_Text(pDX, IDC_URL, mURL);
	DDX_Check(pDX, IDC_REQUIRE_LOGIN, mRequiresLogin);
	DDX_Text(pDX, IDC_USERNAME, mUsername);
	DDX_Text(pDX, IDC_PASSWORD, mPassword);
	DDX_Check(pDX, IDC_AUTOLOGIN, mAutoLogin);
}

BEGIN_MESSAGE_MAP(CEditSiteDlg, CDialog)
	ON_BN_CLICKED(IDC_ADVANCED, OnBnClickedAdvanced)
END_MESSAGE_MAP()

void CEditSiteDlg::OnBnClickedAdvanced()
{
	CSite* site = mSite;
	if (!site)
		return;


	CAdvancedSiteDlg dlg;
	dlg.mFirstName = site->mFormFirstName;
	dlg.mLastName = site->mFormLastName;
	dlg.mFullName = site->mFormFullName;
	dlg.mEmail = site->mFormEmail;
	dlg.mWebsiteTitle = site->mFormWebsiteTitle;
	dlg.mWebsite = site->mFormWebsite;
	dlg.mTitle = site->mFormTitle;
	dlg.mArticle = site->mFormArticle;
	dlg.mCompany = site->mFormCompany;
	dlg.mSubmitter = site->mFormSubmitter;
	dlg.mLogin = site->mFormLogin;
	dlg.mPassword = site->mFormPassword; 
	dlg.mSummary = site->mFormSummary;
	dlg.mBio = site->mFormBio;
	dlg.mLoginSubmit = site->mFormLoginSubmit;
	


	if (dlg.DoModal() == IDOK)
	{
		site->mFormFirstName = dlg.mFirstName;
		site->mFormLastName = dlg.mLastName;
		site->mFormFullName = dlg.mFullName;
		site->mFormEmail = dlg.mEmail;
		site->mFormWebsiteTitle = dlg.mWebsiteTitle;
		site->mFormWebsite = dlg.mWebsite;
		site->mFormTitle = dlg.mTitle;
		site->mFormArticle = dlg.mArticle;
		site->mFormCompany = dlg.mCompany;
		site->mFormSubmitter = dlg.mSubmitter;
		site->mFormLogin = dlg.mLogin;
		site->mFormPassword = dlg.mPassword;
		site->mFormSummary = dlg.mSummary;
		site->mFormBio = dlg.mBio;
		site->mFormLoginSubmit = dlg.mLoginSubmit;

		theApp.mManager.Save();
	}
}
