#include "stdafx.h"
#include "explorer1.h"
#include "ArticleManager.h"
#include "ArticleSubmitterDlg.h"
#include "ArticleSubmitter.h"
#include ".\explorer1.h"
/////////////////////////////////////////////////////////////////////////////
// CExplorer1

IMPLEMENT_DYNCREATE(CExplorer1, CWnd)

/////////////////////////////////////////////////////////////////////////////
// CExplorer1 operations

//event sink
STDMETHODIMP CEventSink::GetTypeInfoCount(UINT* pctinfo)
{
    return E_NOTIMPL;
}

STDMETHODIMP CEventSink::GetTypeInfo(UINT itinfo, LCID lcid,
                                     ITypeInfo** pptinfo)
{
    return E_NOTIMPL;
}

STDMETHODIMP CEventSink::GetIDsOfNames(REFIID riid, LPOLESTR* rgszNames,
                                       UINT cNames, LCID lcid,
                                       DISPID* rgdispid)
{
    return E_NOTIMPL;
}

STDMETHODIMP CEventSink::Invoke(DISPID dispid, REFIID riid, LCID lcid,
                                WORD wFlags, DISPPARAMS* pdispparams,
                                VARIANT* pvarResult, EXCEPINFO* pexcepinfo,
                                UINT* puArgErr)
{
    if (dispid != DISPID_DOCUMENTCOMPLETE)
        return S_OK;

    if (pdispparams->cArgs != 2)
        return S_OK;

    if (pdispparams->rgvarg[0].vt != (VT_VARIANT | VT_BYREF))
        return S_OK;

    if (pdispparams->rgvarg[1].vt != VT_DISPATCH)
        return S_OK;

	mSubmitter->ProcessDocument( pdispparams->rgvarg[1].pdispVal );

    return S_OK;
}


void CExplorer1::ProcessDoc( IHTMLDocument3* doc )
{
	IHTMLElementCollection* pColl = 0;
	doc->getElementsByTagName( L"input", &pColl );

	if (!pColl)
		return;

	long len = 0;
	pColl->get_length( &len );

	for (int a = 0; a < len; a++)
	{
		VARIANT param;
		param.vt = VT_I4;
		param.intVal = a;

		VARIANT var;
		var.vt = VT_INT;
		var.intVal = 0;

		IDispatch* elemdisp = 0;
		HRESULT hr = pColl->item( param, var, (IDispatch**)&elemdisp);

		IHTMLElement* element = 0;
		if (!elemdisp)
			return;
		elemdisp->QueryInterface( IID_IHTMLElement, (void**)&element );

		if (element)
		{
			VARIANT val;
			element->getAttribute( L"name", 0, &val );
		}
	}
}

void CExplorer1::ProcessDocument( IDispatch* pdisp )
{
		
	USES_CONVERSION;

	if (!mSite)
		return;
	if (!mArticle)
		return;


	IHTMLDocument3* pDocument3 = NULL;
	IHTMLDocument2* pDocument  = NULL;
	IHTMLElement2* pElement2   = NULL;
	IHTMLElement* pElement     = NULL;
	IViewObject2* pViewObject  = NULL;
	IDispatch* pDispatch       = NULL;
	IDispatch* pWebBrowserDisp = NULL;


	HRESULT hr = 0;
    

	pDispatch = get_Document();

	if (!pDispatch)
		return;

	hr = pDispatch->QueryInterface(IID_IHTMLDocument2, (void**)&pDocument);

	if (FAILED(hr))
		return;

	hr = pDocument->get_body(&pElement);

	if (FAILED(hr))
		return;

	hr = pDispatch->QueryInterface(IID_IHTMLDocument3, (void**)&pDocument3);

	if (FAILED(hr))
		return;

	IHTMLElementCollection* pColl = 0;
	
	pDocument->get_all( &pColl );

	IHTMLFormElement* form = 0;

	int usernamefound = 0;
	int passwordfound = 0;


	if (pColl)
	{
		long len = 0;
		pColl->get_length( &len );

		for (int a = 0; a < len; a++)
		{
			VARIANT param;
			param.vt = VT_I4;
			param.intVal = a;

			VARIANT var;
			var.vt = VT_INT;
			var.intVal = 0;

			IDispatch* elemdisp = 0;
			HRESULT hr = pColl->item( param, var, (IDispatch**)&elemdisp);

			IHTMLElement* element = 0;
			if (!elemdisp)
				return;
			
			elemdisp->QueryInterface( IID_IHTMLElement, (void**)&element );

			if (element)
			{
				BSTR tagname;
				element->get_tagName( &tagname );

				if (!wcscmp( tagname, L"INPUT") )
				{
					IHTMLInputElement* inputelem = 0;
					element->QueryInterface( IID_IHTMLInputElement, (void**)&inputelem );
					if (inputelem)
					{
						BSTR type;
						inputelem->get_type( &type );
						if (!wcsicmp( type, L"hidden" ))
							continue;

						BSTR name;
						inputelem->get_name( &name );
						if (name)
						{
							if (!wcsicmp( name, A2W( mSite->mFormFirstName )))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mFirstName ) );
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormLastName )))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mLastName ));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormFullName)))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mFullName));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormEmail )))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mEmail ) );
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormWebsiteTitle)))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsiteTitle ));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormWebsite)))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsite ));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormCompany)))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mCompany));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormTitle)))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getTitle()));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormArticle)))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getText()));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormLogin)))
							{
								BSTR namestr = SysAllocString( A2W( mSite->getUsername()));
								if (wcslen( namestr ) == 0)
								{
									namestr = SysAllocString( A2W( theApp.mManager.mUsername ));
								}
								inputelem->put_value( namestr );
								usernamefound = 1;
							}
							else if (!wcsicmp( name, A2W( mSite->mFormPassword)))
							{
								BSTR namestr = SysAllocString( A2W( mSite->getPassword()));
								if (wcslen( namestr ) == 0)
								{
									namestr = SysAllocString( A2W( theApp.mManager.mPassword ));
								}

								inputelem->put_value( namestr );
								inputelem->get_form( &form );
								passwordfound = 1;
							}
							else if (!wcsicmp( name, A2W( mSite->mFormSummary)))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getSummary() ));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormBio )))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mBio ));
								inputelem->put_value( namestr );
							}
							else
							{
								//check generic stuff
								if (theApp.mManager.isFirstName( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mFirstName ) );
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isLastName( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mLastName ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isFullName( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mFullName));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isEmail( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mEmail ) );
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isWebsiteTitle( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsiteTitle ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isWebsite( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsite ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isCompany( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mCompany));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isTitle( name ))
								{
									BSTR namestr = SysAllocString( A2W( mArticle->getTitle()));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isArticle( name ))
								{
									BSTR namestr = SysAllocString( A2W( mArticle->getText()));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isBio( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mBio ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isSummary( name ))
								{
									BSTR namestr = SysAllocString( A2W( mArticle->getSummary() ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isUsername( name ))
								{
									BSTR namestr = SysAllocString( A2W( mSite->getUsername() ));
									if (wcslen( namestr ) == 0)
									{
										namestr = SysAllocString( A2W( theApp.mManager.mUsername ));
									}
									usernamefound = 1;
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isPassword( name ))
								{
									BSTR namestr = SysAllocString( A2W( mSite->getPassword() ));
									if (wcslen( namestr ) == 0)
									{
										namestr = SysAllocString( A2W( theApp.mManager.mPassword ));
									}
									passwordfound = 1;
									inputelem->put_value( namestr );
									inputelem->get_form( &form );
								}
								else if (theApp.mManager.isCountry( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mCountry ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isAddress( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mAddress ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isAddress2( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mAddress2 ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isCity( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mCity ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isState( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mState ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isZip( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mZipCode ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isPhone( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mPhone ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isKeywords( name ))
								{
									BSTR namestr = SysAllocString( A2W( mArticle->getKeywords()));
									inputelem->put_value( namestr );
								}
							}
						}
					}
				}
				else if (!wcscmp( tagname, L"TEXTAREA") )
				{
					IHTMLTextAreaElement* inputelem = 0;
					element->QueryInterface( IID_IHTMLTextAreaElement, (void**)&inputelem );
					if (inputelem)
					{
						BSTR name;
						inputelem->get_name( &name );
						if (name)
						{
							if (!wcsicmp( name, A2W( mSite->mFormFirstName )))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mFirstName ) );
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormLastName )))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mLastName ));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormFullName)))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mFullName));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormEmail )))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mEmail ) );
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormWebsiteTitle)))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsiteTitle ));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormWebsite)))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsite ));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormCompany)))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mCompany));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormTitle)))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getTitle()));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormArticle)))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getText()));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormLogin)))
							{
								BSTR namestr = SysAllocString( A2W( mSite->getUsername()));
								if (wcslen( namestr ) == 0)
								{
									namestr = SysAllocString( A2W( theApp.mManager.mUsername ));
								}
								usernamefound = 1;
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormPassword)))
							{
								BSTR namestr = SysAllocString( A2W( mSite->getPassword()));
								if (wcslen( namestr ) == 0)
								{
									namestr = SysAllocString( A2W( theApp.mManager.mPassword ));
								}
								passwordfound = 1;
								inputelem->put_value( namestr );
								inputelem->get_form( &form );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormSummary)))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getSummary() ));
								inputelem->put_value( namestr );
							}
							else if (!wcsicmp( name, A2W( mSite->mFormBio )))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mBio ));
								inputelem->put_value( namestr );
							}
							else
							{
								//check generic stuff
								if (theApp.mManager.isFirstName( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mFirstName ) );
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isLastName( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mLastName ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isFullName( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mFullName));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isEmail( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mEmail ) );
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isWebsiteTitle( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsiteTitle ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isWebsite( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsite ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isCompany( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mCompany));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isTitle( name ))
								{
									BSTR namestr = SysAllocString( A2W( mArticle->getTitle()));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isArticle( name ))
								{
									BSTR namestr = SysAllocString( A2W( mArticle->getText()));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isBio( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mBio ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isSummary( name ))
								{
									BSTR namestr = SysAllocString( A2W( mArticle->getSummary() ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isCountry( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mCountry ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isAddress( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mAddress ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isAddress2( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mAddress2 ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isCity( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mCity ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isState( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mState ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isZip( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mZipCode ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isPhone( name ))
								{
									BSTR namestr = SysAllocString( A2W( theApp.mManager.mPhone ));
									inputelem->put_value( namestr );
								}
								else if (theApp.mManager.isKeywords( name ))
								{
									BSTR namestr = SysAllocString( A2W( mArticle->getKeywords()));
									inputelem->put_value( namestr );
								}
							}
						}
					}
				}
			}
		}
	}

	if (form && usernamefound && passwordfound)
	{
		if (!mSite->getURL().CompareNoCase( mLastSubmitURL ))
		{
			DWORD timenow = GetTickCount();
			if (timenow - mLastSubmitTime > 15000)
			{ 
				mLastSubmitTime = GetTickCount();
				if (mSite->getAutoLogin())
				{
					form->submit();
				}
			}
			else
			{
			}
		}
		else
		{
			if (mSite->getAutoLogin())
			{
				form->submit();
			}
		}
	}
	mLastSubmitURL = mSite->getURL();
	mLastSubmitTime = GetTickCount();

	if (pDocument3)
		pDocument3->Release();
	if (pDocument)
		pDocument->Release();
	if (pElement2)
		pElement2->Release();
	if (pElement)
		pElement->Release();
	if (pDispatch)
		pDispatch->Release();
}





void CExplorer1::Submit( CArticle* article, CSite* site )
{
	USES_CONVERSION;

	mArticle = article;
	mSite = site;

	IUnknown* mBrowserUnk = 0;
	IDispatch* disp = this->GetIDispatch(1);
	disp->QueryInterface( IID_IUnknown, (void**)&mBrowserUnk);
	if (!mBrowserUnk)
		return;

    HRESULT hr = CComObject<CEventSink>::CreateInstance(&mSink);

    if (FAILED(hr))
        return;

	mSink->AddRef();
	mSink->mSubmitter = this;

    hr = AtlAdvise( mBrowserUnk, mSink->GetUnknown(),
                   DIID_DWebBrowserEvents2, &m_dwCookie);


	Navigate( site->getURL(), 0, 0, 0, 0 );
}


void CExplorer1::HookEvents(  )
{
	USES_CONVERSION;

	IUnknown* mBrowserUnk = 0;
	IUnknown* unk = GetControlUnknown();
	mBrowserUnk = unk;

    HRESULT hr = CComObject<CEventSink>::CreateInstance(&mSink);

    if (FAILED(hr))
        return;

	mSink->AddRef();
	mSink->mSubmitter = this;

    hr = AtlAdvise( mBrowserUnk, mSink->GetUnknown(),
                   DIID_DWebBrowserEvents2, &m_dwCookie);

}












void CExplorer1::FillManual( CManualSite* site, CArticle* article  )
{
	USES_CONVERSION;

	if (!site)
		return;
	if (!article)
		return;


	IHTMLDocument3* pDocument3 = NULL;
	IHTMLDocument2* pDocument  = NULL;
	IHTMLElement2* pElement2   = NULL;
	IHTMLElement* pElement     = NULL;
	IViewObject2* pViewObject  = NULL;
	IDispatch* pDispatch       = NULL;
	IDispatch* pWebBrowserDisp = NULL;


	HRESULT hr = 0;
    

	pDispatch = get_Document();
	if (!pDispatch)
		return;

	hr = pDispatch->QueryInterface(IID_IHTMLDocument2, (void**)&pDocument);
	if (FAILED(hr))
		return;

	hr = pDocument->get_body(&pElement);
	if (FAILED(hr))
		return;

	hr = pDispatch->QueryInterface(IID_IHTMLDocument3, (void**)&pDocument3);
	if (FAILED(hr))
		return;

	IHTMLElementCollection* pColl = 0;
	
	pDocument->get_all( &pColl );

	IHTMLFormElement* form = 0;

	int usernamefound = 0;
	int passwordfound = 0;
	if (pColl)
	{
		long len = 0;
		pColl->get_length( &len );

		for (int a = 0; a < len; a++)
		{
			VARIANT param;
			param.vt = VT_I4;
			param.intVal = a;

			VARIANT var;
			var.vt = VT_INT;
			var.intVal = 0;

			IDispatch* elemdisp = 0;
			HRESULT hr = pColl->item( param, var, (IDispatch**)&elemdisp);

			IHTMLElement* element = 0;
			if (!elemdisp)
				return;
			
			elemdisp->QueryInterface( IID_IHTMLElement, (void**)&element );

			if (element)
			{
				BSTR tagname;
				element->get_tagName( &tagname );

				if (!wcscmp( tagname, L"INPUT") )
				{
					IHTMLInputElement* inputelem = 0;
					element->QueryInterface( IID_IHTMLInputElement, (void**)&inputelem );
					if (inputelem)
					{
						BSTR type;
						inputelem->get_type( &type );
						if (!wcsicmp( type, L"hidden" ))
							continue;

						BSTR name;
						inputelem->get_name( &name );
						if (name)
						{
							//check generic stuff
							if (theApp.mManager.isFirstName( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mFirstName ) );
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isLastName( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mLastName ));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isFullName( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mFullName));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isEmail( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mEmail ) );
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isWebsiteTitle( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsiteTitle ));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isWebsite( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsite ));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isCompany( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mCompany));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isTitle( name ))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getTitle()));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isArticle( name ))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getText()));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isBio( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mBio ));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isSummary( name ))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getSummary() ));
								inputelem->put_value( namestr );
							}
						}
					}
				}
				else if (!wcscmp( tagname, L"TEXTAREA") )
				{
					IHTMLTextAreaElement* inputelem = 0;
					element->QueryInterface( IID_IHTMLTextAreaElement, (void**)&inputelem );
					if (inputelem)
					{
						BSTR name;
						inputelem->get_name( &name );
						if (name)
						{
							//check generic stuff
							if (theApp.mManager.isFirstName( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mFirstName ) );
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isLastName( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mLastName ));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isFullName( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mFullName));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isEmail( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mEmail ) );
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isWebsiteTitle( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsiteTitle ));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isWebsite( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mWebsite ));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isCompany( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mCompany));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isTitle( name ))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getTitle()));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isArticle( name ))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getText()));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isBio( name ))
							{
								BSTR namestr = SysAllocString( A2W( theApp.mManager.mBio ));
								inputelem->put_value( namestr );
							}
							else if (theApp.mManager.isSummary( name ))
							{
								BSTR namestr = SysAllocString( A2W( mArticle->getSummary() ));
								inputelem->put_value( namestr );
							}
						}
					}
				}
			}
		}
	}

	if (pDocument3)
		pDocument3->Release();
	if (pDocument)
		pDocument->Release();
	if (pElement2)
		pElement2->Release();
	if (pElement)
		pElement->Release();
	if (pDispatch)
		pDispatch->Release();
}


BOOL CExplorer1::PreTranslateMessage(MSG* pMsg)
{
/*	if (pMsg->message == WM_RBUTTONDOWN || pMsg->message == WM_RBUTTONDBLCLK
		|| pMsg->message == WM_RBUTTONUP)
	{
		return TRUE;
	}
*/

	return FALSE;
}

