#include "StdAfx.h"
#include ".\articlemanager.h"
#include <afxinet.h>

CArticleManager::CArticleManager(void)
{
	mBrowsing = 0;
}

CArticleManager::~CArticleManager(void)
{
	for (std::vector<CSite*>::iterator i = mAutoSites.begin();
			i < mAutoSites.end(); i++)
	{
		CSite* site = (*i);
		delete site;
	}
	mAutoSites.clear();

	for (std::vector<CArticle*>::iterator i = mArticles.begin();
			i < mArticles.end(); i++)
	{
		CArticle* art = (*i);
		delete art;
	}
	mArticles.clear();
}

void CArticleManager::Init()
{
	Load( _T("artsub.dat") );
	LoadGenericElements();
}

CString readString( CFile& file )
{
	int len = 0;
	file.Read( &len, sizeof( int ) );
	char* buffer = new char[len+1];
	file.Read( buffer, len );
	buffer[len] = 0;
	CString str = buffer;
	delete [] buffer;
	return str;
}

void writeString( CFile& file, CString str )
{
	int len = str.GetLength();
	file.Write( (const char*)&len, sizeof( int ) );
	file.Write( (const char*)str.GetBuffer(0), len );
	str.ReleaseBuffer();
}

void CArticleManager::Save( CString filename )
{
	CFile file;
	if (file.Open( filename, CFile::OpenFlags::modeWrite|CFile::OpenFlags::modeCreate ))
	{
		writeString( file, mFirstName );
		writeString( file, mLastName );
		writeString( file, mFullName );
		writeString( file, mAddress );
		writeString( file, mAddress2 );
		writeString( file, mCity );
		writeString( file, mState );
		writeString( file, mZipCode );
		writeString( file, mCountry );
		writeString( file, mWebsite );
		writeString( file, mWebsiteTitle );
		writeString( file, mEmail );
		writeString( file, mCompany );
		writeString( file, mBio );
		writeString( file, mPhone );
		writeString( file, mUsername );
		writeString( file, mPassword );

		int num = mAutoSites.size();
		file.Write( (const char*)&num, sizeof( int ) );
		for (std::vector<CSite*>::iterator i = mAutoSites.begin();
				i < mAutoSites.end(); i++)
		{
			(*i)->Save( file );
		}

		num = mManualSites.size();
		file.Write( (const char*)&num, sizeof( int ) );
		for (std::vector<CManualSite*>::iterator i = mManualSites.begin();
				i < mManualSites.end(); i++)
		{
			(*i)->Save( file );
		}

		num = mArticles.size();
		file.Write( (const char*)&num, sizeof( int ) );
		for (std::vector<CArticle*>::iterator i = mArticles.begin();
				i < mArticles.end(); i++)
		{
			(*i)->Save( file );
		}


		file.Flush();
		file.Close();
	}
}

void CArticleManager::Load( CString filename )
{
	CFile file;
	if (file.Open( filename, CFile::OpenFlags::modeRead ))
	{
		mFirstName = readString( file );
		mLastName = readString( file );
		mFullName = readString( file );
		mAddress = readString( file );
		mAddress2 = readString( file );
		mCity = readString( file );
		mState = readString( file );
		mZipCode = readString( file );
		mCountry = readString( file );
		mWebsite = readString( file );
		mWebsiteTitle = readString( file );
		mEmail = readString( file );
		mCompany = readString( file );
		mBio = readString( file );
		mPhone = readString( file );
		mUsername = readString( file );
		mPassword = readString( file );

		int num = 0;
		file.Read( &num, sizeof( int ) );
		for (int a = 0; a < num; a++)
		{
			CSite* site = new CSite();
			site->Load( file );
			mAutoSites.push_back( site );
		}

		num = 0;
		file.Read( &num, sizeof( int ) );
		for (int a = 0; a < num; a++)
		{
			CManualSite* site = new CManualSite();
			site->Load( file );
			mManualSites.push_back( site );
		}

		num = 0;
		file.Read( &num, sizeof( int ) );
		for (int a = 0; a < num; a++)
		{
			CArticle* article = new CArticle();
			article->Load( file );
			mArticles.push_back( article );
		}
		file.Close();
	}

/*	CManualSite* mansite = new CManualSite();
	mansite->mTitle = "Link General";
	mansite->mURL = "http://www.linkgeneral.com/logon.asp";
	mManualSites.push_back( mansite );
*/
}


void CArticleManager::Submit( CArticle* article, CSite* site )
{
/*	CSubmitter browser;

	browser.Submit( this, article, site );

	mBrowsing = 1;

	MSG msg;
	while (GetMessage(&msg, 0, 0, 0) && mBrowsing ) 
	{
		if (msg.message != WM_MOUSEMOVE)
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
*/

}

BOOL CArticleManager::PostData2Script(CString url, CString sData)
{
	USES_CONVERSION;
	CString response;
	try
	{
		char sDomain[256];
		char sAction[256];
		URL_COMPONENTS uc;
		ZeroMemory(&uc, sizeof uc);
		uc.dwStructSize = sizeof uc;
		uc.lpszHostName = sDomain;
		uc.dwHostNameLength = sizeof(sDomain);
		uc.lpszUrlPath = sAction;
		uc.dwUrlPathLength=sizeof(sAction);
		if(!InternetCrackUrl(url, (DWORD)url.GetLength(), ICU_DECODE, &uc))
		{
			return FALSE;
		}

		CString strHeaders = _T("Content-Type: application/x-www-form-urlencoded\r\n");
		DWORD len = sData.GetLength()+1;

		CInternetSession session;
		CHttpConnection* pConnection = session.GetHttpConnection(sDomain);
		CHttpFile* pFile = pConnection->OpenRequest(CHttpConnection::HTTP_VERB_POST, sAction, NULL, 1, NULL, NULL, INTERNET_FLAG_TRANSFER_ASCII | INTERNET_FLAG_DONT_CACHE |INTERNET_FLAG_RELOAD);

		BOOL result = pFile->SendRequest( strHeaders, (LPVOID)sData.GetBuffer(0), sData.GetLength());
		sData.ReleaseBuffer();

		DWORD dwContentLen =0;
		DWORD dwBufLen = sizeof(dwContentLen);
		if (!pFile->QueryInfo(HTTP_QUERY_CONTENT_LENGTH| HTTP_QUERY_FLAG_NUMBER, (LPVOID)&dwContentLen,   &dwBufLen, 0)) 
			dwContentLen = 50000;

		char* sBuf = new char[dwContentLen+1];
		dwBufLen = pFile->Read(sBuf, dwContentLen);
		sBuf[dwContentLen] = 0;
		delete pFile;
		delete pConnection;
		response = A2W(sBuf);
		delete [] sBuf;
		return TRUE;
	}
	catch (CException* ex)
	{
		ex->Delete();
		return FALSE;
	}
	catch (...)
	{
		return FALSE;
	}
}



void CArticleManager::LoadGenericElements()
{
	//first name
	mFirstNameElements.push_back( "first_name" );
	mFirstNameElements.push_back( "firstname" );
	mFirstNameElements.push_back( "first" );
	mFirstNameElements.push_back( "f_fname" );
	mFirstNameElements.push_back( "txt_first_name" );
	mFirstNameElements.push_back( "txtFName" );
	mFirstNameElements.push_back( "fname" );

	//last name
	mLastNameElements.push_back( "last_name" );
	mLastNameElements.push_back( "lastname" );
	mLastNameElements.push_back( "last" );
	mLastNameElements.push_back( "f_lname" );
	mLastNameElements.push_back( "txt_last_name" );
	mLastNameElements.push_back( "txtLName" );
	mLastNameElements.push_back( "lname" );

	//full name
	mFullNameElements.push_back( "full_name" );
	mFullNameElements.push_back( "fullname" );
	mFullNameElements.push_back( "full" );
	mFullNameElements.push_back( "txtName" );
	mFullNameElements.push_back( "author" );
	mFullNameElements.push_back( "Submitter" );
	mFullNameElements.push_back( "name" );
	mFullNameElements.push_back( "article_author" );
	mFullNameElements.push_back( "byline" );
	mFullNameElements.push_back( "fromName" );
	mFullNameElements.push_back( "Contact_Name" );
	mFullNameElements.push_back( "authorname" );
	mFullNameElements.push_back( "Contact Name" );
	mFullNameElements.push_back( "posted_by" );
	mFullNameElements.push_back( "Realname" );
	mFullNameElements.push_back( "spare1" );
	mFullNameElements.push_back( "txtByLine" );
	mFullNameElements.push_back( "submitname" );


	//email
	mEmailElements.push_back( "email" );
	mEmailElements.push_back( "e-mail" );
	mEmailElements.push_back( "txtSubmissionEmail" );
	mEmailElements.push_back( "SubmitterEmail" );
	mEmailElements.push_back( "emailaddress" );
	mEmailElements.push_back( "f_emailaddress" );
	mEmailElements.push_back( "f_reemailaddress" );
	mEmailElements.push_back( "Contact_Email" );
	mEmailElements.push_back( "authoremail" );
	mEmailElements.push_back( "Contact Email" );
	mEmailElements.push_back( "author_email" );
	mEmailElements.push_back( "txt_email" );
	mEmailElements.push_back( "spare2" );
	mEmailElements.push_back( "aemail" );
	mEmailElements.push_back( "contact_form_email_reenter" );
	mEmailElements.push_back( "authore" );
	mEmailElements.push_back( "Mail" );
	mEmailElements.push_back( "user_email" );
	mEmailElements.push_back( "email2" );

	//URL
	mWebsiteElements.push_back( "url" );
	mWebsiteElements.push_back( "website" );
	mWebsiteElements.push_back( "site" );
	mWebsiteElements.push_back( "frmHomePg" );
	mWebsiteElements.push_back( "siteurl" );
	mWebsiteElements.push_back( "home_page" );
	mWebsiteElements.push_back( "homepage" );
	mWebsiteElements.push_back( "txt_website_url" );
	mWebsiteElements.push_back( "WebURL" );
	mWebsiteElements.push_back( "txtWebsite" );
	mWebsiteElements.push_back( "articleurl" );
	mWebsiteElements.push_back( "authorw" );
	mWebsiteElements.push_back( "webpage" );

	mWebsiteTitleElements.push_back( "art_webpagetitle" );
	mWebsiteTitleElements.push_back( "urlname" );
	mWebsiteTitleElements.push_back( "txtAnchor" );

	//Title
	mTitleElements.push_back( "title" );
	mTitleElements.push_back( "articletitle" );
	mTitleElements.push_back( "txtTitle" );
	mTitleElements.push_back( "Headline" );
	mTitleElements.push_back( "art_title" );
	mTitleElements.push_back( "article_name" );
	mTitleElements.push_back( "f_arttitle" );
	mTitleElements.push_back( "article_title" );
	mTitleElements.push_back( "caption" );
	mTitleElements.push_back( "subject" );
	mTitleElements.push_back( "arttitle" );
	mTitleElements.push_back( "txt_title" );
	mTitleElements.push_back( "Article Title" );
	mTitleElements.push_back( "txtArticleTitle" );
	mTitleElements.push_back( "cat_title" );
	mTitleElements.push_back( "asubject" );

	//Summary
	mSummaryElements.push_back( "summary" );
	mSummaryElements.push_back( "articlesummary" );
	mSummaryElements.push_back( "article-summary" );
	mSummaryElements.push_back( "txtSummary" );
	mSummaryElements.push_back( "Description" );
	mSummaryElements.push_back( "art_abstract" );
	mSummaryElements.push_back( "f_artsummary" );
	mSummaryElements.push_back( "article_snippet" );
	mSummaryElements.push_back( "txt_heading" );
	mSummaryElements.push_back( "txtArticleDescription" );
	mSummaryElements.push_back( "Synopsis" );
	mSummaryElements.push_back( "ArticleDescription" );
	mSummaryElements.push_back( "abstract" );
	mSummaryElements.push_back( "ShortDescription" );
	mSummaryElements.push_back( "article_summary" );
	mSummaryElements.push_back( "p_bio" );

	//article
	mArticleElements.push_back( "article" );
	mArticleElements.push_back( "body" );
	mArticleElements.push_back( "text" );
	mArticleElements.push_back( "txtArticle" );
	mArticleElements.push_back( "ArticleText" );
	mArticleElements.push_back( "art_content" );
	mArticleElements.push_back( "content" );
	mArticleElements.push_back( "article_body" );
	mArticleElements.push_back( "f_artbody" );
	mArticleElements.push_back( "article_summary_temp" );
	mArticleElements.push_back( "story" );
	mArticleElements.push_back( "artext" );
	mArticleElements.push_back( "txt_content" );
	mArticleElements.push_back( "Article Content" );
	mArticleElements.push_back( "txtArticle" );
	mArticleElements.push_back( "abody" );
	mArticleElements.push_back( "bodytext" );
	mArticleElements.push_back( "ArticleContent" );
	mArticleElements.push_back( "databody" );
	mArticleElements.push_back( "ArticleBody" );
	mArticleElements.push_back( "txtBody" );
	mArticleElements.push_back( "Article_content" );
	mArticleElements.push_back( "comments" );

	//company
	mCompanyElements.push_back( "company" );


	mBioElements.push_back( "txtBio" );
	mBioElements.push_back( "WriterBio" );
	mBioElements.push_back( "bio" );
	mBioElements.push_back( "Signature" );
	mBioElements.push_back( "about" );
	mBioElements.push_back( "f_artres" );
	mBioElements.push_back( "resourcebox" );
	mBioElements.push_back( "frmBio" );
	mBioElements.push_back( "frmByLine" );
	mBioElements.push_back( "abtext" );
	mBioElements.push_back( "AuthorInfo" );
	mBioElements.push_back( "txt_byline" );
	mBioElements.push_back( "txt_user_description" );
	mBioElements.push_back( "bioinfo" );
	mBioElements.push_back( "resource" );
	mBioElements.push_back( "authorbox" );
	mBioElements.push_back( "AboutTheAuthor" );
	mBioElements.push_back( "author_bio" );
	mBioElements.push_back( "txtDesc" );
	mBioElements.push_back( "txtAboutBox" );
	mEmailElements.push_back( "authora" );


	mCompanyElements.push_back( "SubmitterCompany" );
	mCompanyElements.push_back( "Organization" );
	mCompanyElements.push_back( "cname" );
	mCompanyElements.push_back( "company" );

	//login stuff
	mUsernameElements.push_back( "username" );
	mUsernameElements.push_back( "f_username" );	
	mUsernameElements.push_back( "user_name" );
	mUsernameElements.push_back( "uname" );
	mUsernameElements.push_back( "account" );
	mUsernameElements.push_back( "txtUserName" );
	mUsernameElements.push_back( "userid" );
	mUsernameElements.push_back( "Logon" );
	mUsernameElements.push_back( "Nickname" );
	mUsernameElements.push_back( "authname" );
	mUsernameElements.push_back( "penname" );

	
	mPasswordElements.push_back( "password" );
	mPasswordElements.push_back( "password2" );
	mPasswordElements.push_back( "pass" );
	mPasswordElements.push_back( "pass2" );
	mPasswordElements.push_back( "pw" );
	mPasswordElements.push_back( "pw2" );
	mPasswordElements.push_back( "pwd" );
	mPasswordElements.push_back( "pwd2" );
	mPasswordElements.push_back( "passwd" );
	mPasswordElements.push_back( "passwd2" );
	mPasswordElements.push_back( "f_password" );
	mPasswordElements.push_back( "f_password2" );
	mPasswordElements.push_back( "txtPassword1" );
	mPasswordElements.push_back( "txtPassword2" );
	mPasswordElements.push_back( "user_password" );
	mPasswordElements.push_back( "user_password2" );
	mPasswordElements.push_back( "passconfirm" );
	mPasswordElements.push_back( "UserPassword" );
	mPasswordElements.push_back( "UserPassword2" );
	mPasswordElements.push_back( "password_confirm" );
	mPasswordElements.push_back( "f_repassword" );
	mPasswordElements.push_back( "txt_password" );
	mPasswordElements.push_back( "txt_password_confirm" );
	mPasswordElements.push_back( "authpass" );
	mPasswordElements.push_back( "ConfirmPassword" );
	mPasswordElements.push_back( "cpas" );
	mPasswordElements.push_back( "p1" );
	mPasswordElements.push_back( "p2" );
	mPasswordElements.push_back( "authorpass" );


	//address
	//	f_address1
	mAddressElements.push_back( "f_address1" );
	mAddressElements.push_back( "company_address" );
	mAddressElements.push_back( "address1" );
	mAddressElements.push_back( "address" );
	//address2
	//	f_address2
	mAddress2Elements.push_back( "f_address2" );
	mAddress2Elements.push_back( "address2" );


	//city
	mCityElements.push_back( "city" );
	mCityElements.push_back( "f_city" );

	//state
	mStateElements.push_back( "state" );
	mStateElements.push_back( "f_state" );
	mStateElements.push_back( "State_Or_Province" );

	//zip
	mZipElements.push_back( "zip" );
	mZipElements.push_back( "f_zip" );

	//phone
	mPhoneElements.push_back( "phone" );
	mPhoneElements.push_back( "f_phone" );
	mPhoneElements.push_back( "phone1" );

	//country
	mCountryElements.push_back( "country" );

	//keywords
	mKeywordsElements.push_back( "keywords" );
	mKeywordsElements.push_back( "key" );
	mKeywordsElements.push_back( "f_artkey" );
	mKeywordsElements.push_back( "KeyPhrases" );
	mKeywordsElements.push_back( "artkeywords" );
}

void CArticleManager::SaveGenericElements()
{

}
