#include "stdafx.h"
#include "Browser.h"
#include <string>
#include "Browser.h"
#include "ArticleManager.h"


STDMETHODIMP CEventSink::GetTypeInfoCount(UINT* pctinfo)
{
    return E_NOTIMPL;
}

STDMETHODIMP CEventSink::GetTypeInfo(UINT itinfo, LCID lcid,
                                     ITypeInfo** pptinfo)
{
    return E_NOTIMPL;
}

STDMETHODIMP CEventSink::GetIDsOfNames(REFIID riid, LPOLESTR* rgszNames,
                                       UINT cNames, LCID lcid,
                                       DISPID* rgdispid)
{
    return E_NOTIMPL;
}

STDMETHODIMP CEventSink::Invoke(DISPID dispid, REFIID riid, LCID lcid,
                                WORD wFlags, DISPPARAMS* pdispparams,
                                VARIANT* pvarResult, EXCEPINFO* pexcepinfo,
                                UINT* puArgErr)
{
	if (dispid == DISPID_NEWWINDOW || dispid == DISPID_NEWWINDOW2 || dispid == DISPID_NAVIGATEERROR)
	{
//		m_pMain->mParentDB->setError();
//		m_pMain->DestroyWindow();
		return -1;
	}
    if (dispid != DISPID_DOCUMENTCOMPLETE)
        return S_OK;

    if (pdispparams->cArgs != 2)
        return S_OK;

    if (pdispparams->rgvarg[0].vt != (VT_VARIANT | VT_BYREF))
        return S_OK;

    if (pdispparams->rgvarg[1].vt != VT_DISPATCH)
        return S_OK;

	int test5 = 0;

/*    if (m_pMain->SaveSnapshot(pdispparams->rgvarg[1].pdispVal,
                              pdispparams->rgvarg[0].pvarVal))
	{
        m_pMain->PostMessage(WM_CLOSE);
		m_pMain->mDone = 1;
	}
*/

    return S_OK;
}


//////////////////////////////////////////////////////////////////
// Implementation of CBrowser Messages
//////////////////////////////////////////////////////////////////
LRESULT CBrowser::OnCreate(UINT nMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	mDone = 0;
    HRESULT hr;
    RECT old;
    IUnknown * pUnk = NULL;
    GetClientRect(&old);

	//register the AtlAxWin class which implements ATL containment
	//this is not needed for an ATL composite control
	//AtlAxWinInit();
	CAxWindow wnd;		
	wnd.Create(m_hWnd, old, m_URI,
		WS_CHILD|WS_DISABLED, 0, (HMENU)NULL);

	if (wnd.m_hWnd == NULL)
		return 1;

	m_hwndWebBrowser = wnd.m_hWnd;
    hr = AtlAxGetControl(m_hwndWebBrowser, &m_pWebBrowserUnk);

    if (FAILED(hr))
        return 1;

    if (m_pWebBrowserUnk == NULL)
        return 1;

    hr = m_pWebBrowserUnk->QueryInterface(IID_IWebBrowser2, (void**)&m_pWebBrowser);

    if (FAILED(hr))
        return 1;

    hr = CComObject<CEventSink>::CreateInstance(&m_pEventSink);

    if (FAILED(hr))
        return 1;

    m_pEventSink->m_pMain = this;

	
    hr = AtlAdvise(m_pWebBrowserUnk, m_pEventSink->GetUnknown(),
                   DIID_DWebBrowserEvents2, &m_dwCookie);

   if (FAILED(hr))
        return 1;

    return 0;
}


LRESULT CBrowser::OnSize(UINT nMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
    if (m_hwndWebBrowser != NULL)
        ::MoveWindow(m_hwndWebBrowser, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);

    return 0;
}

LRESULT CBrowser::OnDestroy(UINT nMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
    HRESULT hr;

    if (m_dwCookie != 0)
        hr = AtlUnadvise(m_pWebBrowserUnk, DIID_DWebBrowserEvents2, m_dwCookie);

    m_pWebBrowser.Release();
    m_pWebBrowserUnk.Release();

    PostQuitMessage(0);

	mDone = 1;
    return 0;
}

//////////////////////////////////////////////////////////////////
// Implementation of CBrowser::SaveSnapshot
//////////////////////////////////////////////////////////////////
BOOL CBrowser::SaveSnapshot(IDispatch* pdisp, VARIANT* purl)
{
/*
	IHTMLDocument3* pDocument3 = NULL;
	IHTMLDocument2* pDocument  = NULL;
	IHTMLElement2* pElement2   = NULL;
	IHTMLElement* pElement     = NULL;
	IViewObject2* pViewObject  = NULL;
	IDispatch* pDispatch       = NULL;
	IDispatch* pWebBrowserDisp = NULL;

	HRESULT hr;
	long bodyHeight;
	long bodyWidth;
	long rootHeight;
	long rootWidth;
	long height;
	long width;

	hr = m_pWebBrowser->get_Document(&pDispatch);

	if (FAILED(hr))
		return true;

	hr = m_pWebBrowserUnk->QueryInterface(IID_IDispatch, (void**)&pWebBrowserDisp);
	
	if (FAILED(hr))
		return true;

	if (pWebBrowserDisp != pdisp)
	{
		pWebBrowserDisp->Release();
		return false;
	}

	hr = pDispatch->QueryInterface(IID_IHTMLDocument2, (void**)&pDocument);

	if (FAILED(hr))
		return true;

	//parse it for CSS here
	parseForCSS( pDocument );

	hr = pDocument->get_body(&pElement);

	if (FAILED(hr))
		return true;

	hr = pElement->QueryInterface(IID_IHTMLElement2, (void**)&pElement2);

	if (FAILED(hr))
		return true;

	hr = pElement2->get_scrollHeight(&bodyHeight);

	if (FAILED(hr))
		return true;

	hr = pElement2->get_scrollWidth(&bodyWidth);

	if (FAILED(hr))
		return true;

	hr = pDispatch->QueryInterface(IID_IHTMLDocument3, (void**)&pDocument3);

	if (FAILED(hr))
		return true;

	hr = pDocument3->get_documentElement(&pElement);

	if (FAILED(hr))
		return true;

	hr = pElement->QueryInterface(IID_IHTMLElement2, (void**)&pElement2);

	if (FAILED(hr))
		return true;

	hr = pElement2->get_scrollHeight(&rootHeight);

	if (FAILED(hr))
		return true;

	hr = pElement2->get_scrollWidth(&rootWidth);

	if (FAILED(hr))
		return true;

	width = bodyWidth;
	height = rootHeight > bodyHeight ? rootHeight : bodyHeight;

	MoveWindow(0, 0, width, height, TRUE);      
	::MoveWindow(m_hwndWebBrowser, 0, 0, width, height, TRUE);

	hr = m_pWebBrowser->QueryInterface(IID_IViewObject2, (void**)&pViewObject);

	if (FAILED(hr))
		return true;

	HDC hdCBrowser = GetDC();
	HDC hdcMem = CreateCompatibleDC(hdCBrowser);
	HBITMAP hBitmap = CreateCompatibleBitmap(hdCBrowser, width, height);
	SelectObject(hdcMem, hBitmap);

	RECTL rcBounds = { 0, 0, width, height };
	hr = pViewObject->Draw(DVASPECT_CONTENT, -1, NULL, NULL, hdCBrowser,
							hdcMem, &rcBounds, NULL, NULL, 0);

	if (SUCCEEDED(hr))
	{
		CImage image;
		image.Create(width, height, 24);
		CImageDC imageDC(image);
		::BitBlt(imageDC, 0, 0, width, height, hdcMem, 0, 0, SRCCOPY);
		image.Save(m_fileName);
	}

	DeleteDC( hdcMem );
	DeleteObject( hBitmap );


	if (pDocument3)
		pDocument3->Release();
	if (pDocument)
		pDocument->Release();
	if (pElement2)
		pElement2->Release();
	if (pElement)
		pElement->Release();
	if (pDispatch)
		pDispatch->Release();

	pViewObject->Release();
	pWebBrowserDisp->Release();		


	mDone = 1;
	return true;
*/

	return 0;
}

LRESULT CBrowser::OnMoving(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	// TODO: Add your message handler code here and/or call default

	return 0;
}
