#pragma once
//#include <stdlib.h>
#include <windows.h>
#include <mshtml.h>
#include <exdispid.h>
#include <atlbase.h>
#include <atlwin.h>
#include <atlcom.h>
#include <atlhost.h>
#include <atlimage.h>

class CBrowser;
class CEventSink;
class CArticle;
class CSite;

class CEventSink :
    public CComObjectRootEx <CComSingleThreadModel>,
    public IDispatch
{
public:
    CEventSink() : m_pMain(NULL) {}

public:

    BEGIN_COM_MAP(CEventSink)
        COM_INTERFACE_ENTRY(IDispatch)
        COM_INTERFACE_ENTRY_IID(DIID_DWebBrowserEvents2, IDispatch)
    END_COM_MAP()

    STDMETHOD(GetTypeInfoCount)(UINT* pctinfo);
    STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo** pptinfo);
    STDMETHOD(GetIDsOfNames)(REFIID riid, LPOLESTR* rgszNames, UINT cNames, LCID lcid, DISPID* rgdispid);
    STDMETHOD(Invoke)(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS* pdispparams,
                      VARIANT* pvarResult, EXCEPINFO* pexcepinfo, UINT* puArgErr);

public:
    CBrowser* m_pMain;
};

//////////////////////////////////////////////////////////////////
// CMain
//////////////////////////////////////////////////////////////////
class CBrowser :
    public CWindowImpl <CBrowser>
{
public:

    CBrowser() : m_dwCookie(0) { }

public:

    BEGIN_MSG_MAP(CMainWindow)
        MESSAGE_HANDLER(WM_CREATE,  OnCreate)
        MESSAGE_HANDLER(WM_SIZE,    OnSize)
        MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_MOVING, OnMoving)
	END_MSG_MAP()

public:

    LRESULT OnCreate  (UINT nMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
    LRESULT OnSize    (UINT nMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
    LRESULT OnDestroy (UINT nMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);

public:

    BOOL SaveSnapshot(IDispatch* pdisp, VARIANT* purl);

public:
    LPCTSTR m_URI;
    LPCTSTR m_fileName;
	int mDone;

public:
    CComPtr<IUnknown> m_pWebBrowserUnk;
    CComPtr<IWebBrowser2> m_pWebBrowser;
    CComObject<CEventSink>* m_pEventSink;
    HWND m_hwndWebBrowser;
    DWORD m_dwCookie;

	CArticle* mArticle;
	CSite* mSite;

	LRESULT OnMoving(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
};
