#pragma once
//#include <stdlib.h>
#include <windows.h>
#include <mshtml.h>
#include <exdispid.h>
#include <atlbase.h>
#include <atlwin.h>
#include <atlcom.h>
#include <atlhost.h>
#include <atlimage.h>

class CArticleManager;

class CArticle;
class CSite;
class CEventSink;
class CSubmitter;
class CEventSink;
class CArticle;
class CSite;

class CEventSink :
    public CComObjectRootEx <CComSingleThreadModel>,
    public IDispatch
{
public:
    CEventSink() : mSubmitter(NULL) {}

public:

    BEGIN_COM_MAP(CEventSink)
        COM_INTERFACE_ENTRY(IDispatch)
        COM_INTERFACE_ENTRY_IID(DIID_DWebBrowserEvents2, IDispatch)
    END_COM_MAP()

    STDMETHOD(GetTypeInfoCount)(UINT* pctinfo);
    STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo** pptinfo);
    STDMETHOD(GetIDsOfNames)(REFIID riid, LPOLESTR* rgszNames, UINT cNames, LCID lcid, DISPID* rgdispid);
    STDMETHOD(Invoke)(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS* pdispparams,
                      VARIANT* pvarResult, EXCEPINFO* pexcepinfo, UINT* puArgErr);

public:
    CSubmitter* mSubmitter;
};


class CSubmitter
{
	protected:
		CArticleManager* mManager;
		CArticle* mArticle;
		CSite* mSite;
		CComObject<CEventSink>* mSink;
		DWORD m_dwCookie;
		IWebBrowser2* mBrowser;
		IUnknown* mBrowserUnk;

	public:
		CSubmitter(void);
		~CSubmitter(void);

		void Submit( CArticleManager* manager, CArticle* article, CSite* site );
		void ProcessDocument( IDispatch* pdisp );
		void ProcessDoc( IHTMLDocument3* doc );
};
