#include "stdafx.h"
#include "ASTabCtrl.h"
#include <atlimage.h>
#include ".\astabctrl.h"

// GBWTabCtrl
  
IMPLEMENT_DYNAMIC(CASTabCtrl, CTabCtrl)
CASTabCtrl::CASTabCtrl()
{
	mCurDialog = 0;
}
    
CASTabCtrl::~CASTabCtrl()
{
}


BEGIN_MESSAGE_MAP(CASTabCtrl, CTabCtrl)
	ON_NOTIFY_REFLECT(TCN_SELCHANGE, OnTcnSelchange)
//	ON_WM_PAINT()
ON_WM_SIZE()
ON_WM_ERASEBKGND()
ON_WM_PAINT()
END_MESSAGE_MAP()


void CASTabCtrl::addDialog( int id, CString title, CDialog* dlg )
{
	InsertItem( (int)mDialogs.GetCount(), title );
	dlg->Create( id, GetParent() );
	mDialogs.Add( dlg );
	mDialogID.Add( id );
}

void CASTabCtrl::addDialog( int id, CString title, CDialog* dlg, int image )
{
	InsertItem( (int)mDialogs.GetCount(), title, image );
	dlg->Create( id, GetParent() );
	mDialogs.Add( dlg );
	mDialogID.Add( id );
}

void CASTabCtrl::initDialogs()
{
}

void CASTabCtrl::activateTabs()
{
	int nSel = GetCurSel();
	
	if(mDialogs[nSel]->m_hWnd)
		mDialogs[nSel]->ShowWindow(SW_HIDE);

	mCurDialog = mDialogs[nSel];

	CRect l_rectClient;
	CRect l_rectWnd;

	GetClientRect(l_rectClient);
	AdjustRect(FALSE,l_rectClient);
	GetWindowRect(l_rectWnd);
	GetParent()->ScreenToClient(l_rectWnd);
	l_rectClient.OffsetRect(l_rectWnd.left,l_rectWnd.top);
	for(int nCount=0; nCount < mDialogs.GetCount(); nCount++)
	{
		mDialogs[nCount]->SetWindowPos(&wndTop, l_rectClient.left, l_rectClient.top, l_rectClient.Width(), l_rectClient.Height(), SWP_HIDEWINDOW);
	}
	mDialogs[nSel]->SetWindowPos(&wndTop, l_rectClient.left, l_rectClient.top, l_rectClient.Width(), l_rectClient.Height(), SWP_SHOWWINDOW);
	mDialogs[nSel]->ShowWindow(SW_SHOW);
}

void CASTabCtrl::OnTcnSelchange(NMHDR *pNMHDR, LRESULT *pResult)
{
   activateTabs();
   *pResult = 0;
}


void CASTabCtrl::OnSize(UINT nType, int cx, int cy)
{

	CDialog* dlg = (CDialog*)GetParent();
/*	CRect r1;
	dlg->GetWindowRect( &r1 );

	CRect r2;
	GetWindowRect( &r2 );

	int x1 = (r2.left - r1.left)-5;
	int y1 = (r2.top - r1.top)-5;
*/

	RECT r;
	GetClientRect( &r );
	int x = r.left;
	int y = r.top;
	int w = r.right - r.left;
	int h = r.bottom - r.top;

	for (int a = 0; a < mDialogs.GetCount(); a++)
	{
		if (a == GetCurSel())
		{
//			CDialog* dlg = mDialogs[a];
//			dlg->SetWindowPos(&wndTop, x, y, w, h, SWP_SHOWWINDOW);
		}
//		mDialogs[nSel]->ShowWindow(SW_SHOW);
//		dlg->MoveWindow( x, y, w, h, 0);
	}

	int nSel = GetCurSel();
	CRect l_rectClient;
	CRect l_rectWnd;
	GetClientRect(l_rectClient);
	AdjustRect(FALSE,l_rectClient);
	GetWindowRect(l_rectWnd);
	GetParent()->ScreenToClient(l_rectWnd);
	l_rectClient.OffsetRect(l_rectWnd.left,l_rectWnd.top);
	mDialogs[nSel]->SetWindowPos(&wndTop, l_rectClient.left, l_rectClient.top, l_rectClient.Width(), l_rectClient.Height(), SWP_SHOWWINDOW);

	CTabCtrl::OnSize(nType, cx, cy);
}

BOOL CASTabCtrl::OnEraseBkgnd(CDC* pDC)
{
	return TRUE;
	RECT r1;
	GetClientRect( &r1 );
	r1.left += 5;
	r1.top += 25;
	r1.right -= 5;
	r1.bottom -= 5;

	pDC->ExcludeClipRect( &r1 );

	return CTabCtrl::OnEraseBkgnd(pDC);
}

void CASTabCtrl::OnPaint()
{
	CPaintDC dc(this); // device context for painting

	COLORREF bgcolor  = dc.GetBkColor();
	// KStowell - Get the client rect.
	CRect rcClient;
	GetClientRect( &rcClient );

	// KStowell - Create a memory device-context. This is done to help reduce
	// screen flicker, since we will paint the entire control to the
	// off screen device context first.
	CDC memDC;
	CBitmap bitmap;
	memDC.CreateCompatibleDC(&dc);
	bitmap.CreateCompatibleBitmap(&dc, rcClient.Width(), rcClient.Height());
	CBitmap* pOldBitmap = memDC.SelectObject(&bitmap);

	// KStowell - Repaint the background.
	memDC.FillSolidRect( rcClient, bgcolor );

	// let the control do its default drawing.
	CWnd::DefWindowProc( WM_PAINT, (WPARAM)memDC.m_hDC, 0 );

	// KStowell - Copy the memory device context back into the original DC via BitBlt().
	dc.BitBlt(rcClient.left, rcClient.top, rcClient.Width(), rcClient.Height(), &memDC, 0,0, SRCCOPY);

	// KStowell - Cleanup resources.
	memDC.SelectObject(pOldBitmap);
	memDC.DeleteDC();
	bitmap.DeleteObject();
}
