#include "stdafx.h"
#include "ArticleSubmitter.h"
#include "ArticleSubmitterDlg.h"
#include "StatLink.h"
#include ".\articlesubmitterdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	CString mTitle;
	CString mAbout1;
	CString mAbout2;
	CString mAbout3;
	CString mAboutURL;

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnInitDialog();
	CStaticLink mAboutURLCtrl;
	CStatic mAbout1Ctrl;
	CStatic mAbout2Ctrl;
	CStatic mAbout3Ctrl;
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ABOUT_LINK, mAboutURLCtrl);
	DDX_Control(pDX, IDC_ABOUT1, mAbout1Ctrl);
	DDX_Control(pDX, IDC_ABOUT2, mAbout2Ctrl);
	DDX_Control(pDX, IDC_ABOUT3, mAbout3Ctrl);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

BOOL CAboutDlg::OnInitDialog()
{
	mAboutURL = theApp.mManager.mAboutURL;
	mAbout1 = theApp.mManager.mAbout1;
	mAbout2 = theApp.mManager.mAbout2;
	mAbout3 = theApp.mManager.mAbout3;
	mTitle = theApp.mManager.mAppName;

	CDialog::OnInitDialog();
	mAboutURLCtrl.SetWindowText( mAboutURL );
	mAboutURLCtrl.m_link = mAboutURL;

	mAbout1Ctrl.SetWindowText( mAbout1 );
	mAbout2Ctrl.SetWindowText( mAbout2 );
	mAbout3Ctrl.SetWindowText( mAbout3 );

	SetWindowText( mTitle );
	return TRUE;
}

// CArticleSubmitterDlg dialog



CArticleSubmitterDlg::CArticleSubmitterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CArticleSubmitterDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	mSizeInited = 0;
	mCurArticle = 0;
}

void CArticleSubmitterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB1, mMainTab);
	DDX_Control(pDX, ID_HELP, mHelpButton);
	DDX_Control(pDX, IDC_HEADER, mHeader);
}

BEGIN_MESSAGE_MAP(CArticleSubmitterDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	ON_WM_GETMINMAXINFO()
	ON_WM_CLOSE()
	ON_BN_CLICKED(ID_HELP, OnBnClickedHelp)
	ON_COMMAND(ID_ABOUT, OnAbout)
END_MESSAGE_MAP()


// CArticleSubmitterDlg message handlers

BOOL CArticleSubmitterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	SetWindowText( theApp.mManager.mAppName );
	// setup the tab control
	//create image list for main tab ctrl
	mImageList.Create(16, 16, ILC_COLOR32, 0, 8);
	mImageList.Add( AfxGetApp()->LoadIcon( IDI_ICON1 ) );
	mImageList.Add( AfxGetApp()->LoadIcon( IDI_ICON3 ) );
	mImageList.Add( AfxGetApp()->LoadIcon( IDI_ICON4 ) );
	mImageList.Add( AfxGetApp()->LoadIcon( IDI_ICON5 ) );
	mImageList.Add( AfxGetApp()->LoadIcon( IDI_ICON6 ) );
	mImageList.Add( AfxGetApp()->LoadIcon( IDI_ICON7 ) );
	mMainTab.SetImageList( &mImageList );
  
	//Add dialogs to main tab control
	mMainTab.addDialog( IDD_SETUP, _T("User Information"), &mSetupDlg, 0 );
	mMainTab.addDialog( IDD_ARTICLES_DLG, _T("Articles"), &mArticlesDlg, 1 );
	mMainTab.addDialog( IDD_SITES_DLG, _T("Websites"), &mSitesDlg, 2 );
	mMainTab.addDialog( IDD_AUTOSUBMIT_DLG, _T("Automatic Submission"), &mAutoSubmissionDlg, 3 );
	mMainTab.addDialog( IDD_MANUALSUBMIT_DLG, _T("Manual Submission"), &mManualSubmissionDlg, 4 );
	mMainTab.activateTabs();

	RECT r;
	GetClientRect( &r );
	int w = r.right - r.left;
	int h = r.bottom - r.top;
	sizeControls( w, h );
	mSizeInited = 1;

	mHeader.EnableScrollBar( SB_VERT, ESB_DISABLE_BOTH );
	mHeader.Navigate( theApp.mManager.mHeaderURL, 0, 0, 0, 0 );



	//set the setup info

	mSetupDlg.mFirstName = theApp.mManager.mFirstName;
	mSetupDlg.mLastName = theApp.mManager.mLastName;
	mSetupDlg.mFullName = theApp.mManager.mFullName;
	mSetupDlg.mWebsite = theApp.mManager.mWebsite;
	mSetupDlg.mWebsiteTitle = theApp.mManager.mWebsiteTitle;
	mSetupDlg.mEmail = theApp.mManager.mEmail;
	mSetupDlg.mCompany = theApp.mManager.mCompany;
	mSetupDlg.mBio = theApp.mManager.mBio;
	mSetupDlg.mAddress = theApp.mManager.mAddress;
	mSetupDlg.mAddress2 = theApp.mManager.mAddress2;
	mSetupDlg.mCity = theApp.mManager.mCity;
	mSetupDlg.mState = theApp.mManager.mState;
	mSetupDlg.mZip = theApp.mManager.mZipCode;
	mSetupDlg.mPhone = theApp.mManager.mPhone;
	mSetupDlg.mUsername = theApp.mManager.mUsername;
	mSetupDlg.mPassword = theApp.mManager.mPassword;
	mSetupDlg.mCountry = theApp.mManager.mCountry;
	mSetupDlg.UpdateData(0);

	//add manual sites
	for (std::vector<CManualSite*>::iterator i = theApp.mManager.mManualSites.begin();
		i < theApp.mManager.mManualSites.end(); i++)
	{
		int id = mManualSubmissionDlg.mSiteCombo.AddString( (*i)->mTitle );
		mManualSubmissionDlg.mSiteCombo.SetItemData( id, (DWORD_PTR)(*i) );
	}
	return TRUE;
}

void CArticleSubmitterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CArticleSubmitterDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CArticleSubmitterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
		return;

		CPaintDC dc(this); // device context for painting

		// KStowell - Get the client rect.
		CRect rcClient;
		GetClientRect( &rcClient );

		// KStowell - Create a memory device-context. This is done to help reduce
		// screen flicker, since we will paint the entire control to the
		// off screen device context first.
		CDC memDC;
		CBitmap bitmap;
		memDC.CreateCompatibleDC(&dc);
		bitmap.CreateCompatibleBitmap(&dc, rcClient.Width(), rcClient.Height());
		CBitmap* pOldBitmap = memDC.SelectObject(&bitmap);

		COLORREF bg = dc.GetBkColor();
		// KStowell - Repaint the background.
		memDC.FillSolidRect( rcClient, bg );

		// let the control do its default drawing.
		CWnd::DefWindowProc( WM_PAINT, (WPARAM)memDC.m_hDC, 0 );

		// KStowell - Copy the memory device context back into the original DC via BitBlt().
		dc.BitBlt(rcClient.left, rcClient.top, rcClient.Width(), rcClient.Height(), &memDC, 0,0, SRCCOPY);

		// KStowell - Cleanup resources.
		memDC.SelectObject(pOldBitmap);
		memDC.DeleteDC();
		bitmap.DeleteObject();
	}
//		CDialog::OnPaint();
//	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CArticleSubmitterDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CArticleSubmitterDlg::OnSize(UINT nType, int cx, int cy)
{
	if (mSizeInited)
	{
//		mMainTab.GetClientRect( &mExcludeRect );
//		mExcludeRect.right -= 100;
	}

	CDialog::OnSize(nType, cx, cy);

	if (mSizeInited)
		sizeControls( cx, cy );
}

void CArticleSubmitterDlg::sizeControls( int cx, int cy )
{
	//the main tab window
	mHeader.MoveWindow( 5, 5, cx - 10, 100 );
	mMainTab.MoveWindow( 5, 105, cx - 10, cy - 150, 0 );

	RECT r5;
	GetClientRect( &r5 );
	r5.top = 105 + (cy-150);
	InvalidateRect( &r5 );

	mMainTab.GetClientRect( &r5 );
	r5.top = 25;
	r5.left = 0;
	r5.right = 10;
	mMainTab.InvalidateRect( &r5 );

	mMainTab.GetClientRect( &r5 );
	r5.top = 25;
	r5.left = r5.right - 10;
	mMainTab.InvalidateRect( &r5 );

	mMainTab.GetClientRect( &r5 );
	r5.top = r5.bottom - 10;;
	mMainTab.InvalidateRect( &r5 );

	//the close button
	RECT r1;
	mHelpButton.GetWindowRect( &r1 );

	int w = r1.right - r1.left;
	int h = r1.bottom - r1.top;

	//the help button
	mHelpButton.MoveWindow( (cx - 10)-w, (cy-h)-5, w, h );
}


BOOL CArticleSubmitterDlg::OnEraseBkgnd(CDC* pDC)
{
	return CDialog::OnEraseBkgnd(pDC);
}


void CArticleSubmitterDlg::StartAuto()
{
	//get all checked
	theApp.mManager.mCheckedSites.clear();

	int nItem = 0;
	for(nItem = 0; nItem < mSitesDlg.mSiteList.GetItemCount(); nItem++)
	{
		BOOL bChecked = mSitesDlg.mSiteList.GetCheck(nItem);
		if( bChecked )
		{ 
			CSite* site = (CSite*)mSitesDlg.mSiteList.GetItemData( nItem );
			theApp.mManager.mCheckedSites.push_back( site );
		}
	}
	mAutoSubmissionDlg.StartAuto();
}

void CArticleSubmitterDlg::OnGetMinMaxInfo(MINMAXINFO* lpMMI)
{
	CDialog::OnGetMinMaxInfo(lpMMI);
	lpMMI->ptMinTrackSize.x = 700;
	lpMMI->ptMinTrackSize.y = 580;
}

BOOL CArticleSubmitterDlg::PreTranslateMessage(MSG* pMsg)
{
	if (pMsg->message == WM_KEYDOWN)
	{
		return TRUE;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CArticleSubmitterDlg::OnOK()
{
//	CDialog::OnOK();
}

void CArticleSubmitterDlg::OnCancel()
{
	CDialog::OnCancel();
}

void CArticleSubmitterDlg::OnClose()
{
	CDialog::OnClose();
}

void CArticleSubmitterDlg::OnBnClickedHelp()
{
	CString url = "\"";
	url += theApp.mManager.mHelpURL;
	url += "\"";

	CString iestr = "iexplore.exe";
//	iestr += url;

	ShellExecute(m_hWnd, "open", iestr, "http://www.viralarticlepublisher.com/help", "", SW_SHOW);
}

void CArticleSubmitterDlg::OnAbout()
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}
