#include "stdafx.h"
#include "ArticleSubmitter.h"
#include "SitesDlg.h"
#include "AdvancedSiteDlg.h"
#include "EditSiteDlg.h"
#include "NewSiteDlg.h"
#include ".\sitesdlg.h"

int gSortDir = 0; //0 = ascending, 1 = descending
static int CALLBACK mySiteCompare( LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort );

 
// CSitesDlg dialog
IMPLEMENT_DYNAMIC(CSitesDlg, CDialog)
CSitesDlg::CSitesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSitesDlg::IDD, pParent)
{
	mSizeInited = 0;
	mSelectedAll = 0;
}

CSitesDlg::~CSitesDlg()
{
}

void CSitesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SITELIST, mSiteList);
	DDX_Control(pDX, IDC_UPDATE, mUpdateButton);
	DDX_Control(pDX, IDC_STATIC, mInfoLabel);
	DDX_Control(pDX, IDC_CREATE, mCreateButton);
	DDX_Control(pDX, IDC_DELETE, mDeleteButton);
	DDX_Control(pDX, IDC_SELECTALL, mSelectAllButton);
}


BEGIN_MESSAGE_MAP(CSitesDlg, CDialog)
	ON_BN_CLICKED(IDC_CREATE, OnBnClickedCreate)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_SITELIST, OnLvnItemchangedSitelist)
	ON_BN_CLICKED(IDC_UPDATE, OnBnClickedUpdate)
	ON_BN_CLICKED(IDC_ADVANCED, OnBnClickedAdvanced)
	ON_WM_SIZE()
	ON_NOTIFY(NM_DBLCLK, IDC_SITELIST, OnNMDblclkSitelist)
	ON_NOTIFY(NM_KILLFOCUS, IDC_SITELIST, OnNMKillfocusSitelist)
	ON_BN_CLICKED(IDC_SELECTALL, OnBnClickedSelectall)
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_SITELIST, OnLvnColumnclickSitelist)
	ON_WM_ERASEBKGND()
	ON_BN_CLICKED(IDC_DELETE, OnBnClickedDelete)
	ON_NOTIFY(HDN_ITEMDBLCLICK, 0, OnHdnItemdblclickSitelist)
END_MESSAGE_MAP()


// CSitesDlg message handlers
BOOL CSitesDlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	mSiteList.SetExtendedStyle( mSiteList.GetExtendedStyle() | LVS_EX_FULLROWSELECT |LVS_EX_CHECKBOXES);
	mSiteList.EnableToolTips(TRUE);

	mSiteList.InsertColumn( 0, _T("Site Name"), LVCFMT_LEFT, 350 );

	RECT r;
	mSiteList.GetClientRect( &r );
//	mSiteList.InsertColumn( 1, _T("Last Modified"), LVCFMT_LEFT, (r.right-r.left) - 350);


	std::vector<CSite*>& sites = theApp.mManager.getAutoSites();

	for (std::vector<CSite*>::iterator i = sites.begin();
			i < sites.end(); i++)
	{
		CString name = (*i)->getName();
		CString url = (*i)->getURL();
		CString modtime = _T("Today");

		LVITEM item1;
		ZeroMemory( &item1, sizeof( LVITEM ) );
		item1.mask = LVIF_IMAGE|LVIF_PARAM;
		item1.lParam = (DWORD)(*i);
		item1.iImage = 0;
		item1.iItem = 0;

		int id = mSiteList.InsertItem( &item1 );

		mSiteList.SetItemText( id, 0, name );
//		mSiteList.SetItemText( id, 1, modtime );

		mSiteList.SetItemToolTipText( id, 0, url );
	}
	mSiteList.SortItems( mySiteCompare, (DWORD_PTR)&mSiteList);
	mSizeInited = 1;
	return TRUE;
}

void CSitesDlg::OnBnClickedCreate()
{
	CNewSiteDlg dlg;
	if (dlg.DoModal() == IDOK)
	{
		CSite* site = new CSite();
		site->setName( dlg.mSiteName );
		site->setURL( dlg.mURL );
		site->setRegFlag( dlg.mRequiresLogin );
		site->setUsername( dlg.mUsername );
		site->setPassword( dlg.mPassword );
		theApp.mManager.addAutoSite( site );
		theApp.mManager.Save();

		//update the text in the list control
		//add it to the site list
		LVITEM item1;
		ZeroMemory( &item1, sizeof( LVITEM ) );
		item1.mask = LVIF_IMAGE|LVIF_PARAM;
		item1.lParam = (DWORD)site;
		item1.iImage = 0;
		item1.iItem = 0;

		int id = mSiteList.InsertItem( &item1 );

		mSiteList.SetItemText( id, 0, site->getName() );
		mSiteList.SetItemToolTipText( id, 0, site->getURL() );
	}
	UpdateData(0);

}

void CSitesDlg::OnLvnItemchangedSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	*pResult = 0;

	//get all checked
	theApp.mManager.mCheckedSites.clear();


	int nItem = 0;
	for(nItem = 0; nItem < mSiteList.GetItemCount(); nItem++)
	{
		BOOL bChecked = mSiteList.GetCheck(nItem);
		if( bChecked == 1 )
		{ 
			CSite* site = (CSite*)mSiteList.GetItemData( nItem );
			theApp.mManager.mCheckedSites.push_back( site );
		}
	}
	theApp.mDialog->mAutoSubmissionDlg.UpdateSites();
}

void CSitesDlg::OnBnClickedUpdate()
{
	int pos = mSiteList.GetSelectionMark();

	if (pos == -1)
		return;

	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.iItem = (UINT)pos;
	item1.mask = LVIF_PARAM;
	mSiteList.GetItem( &item1 );

	CSite* site = (CSite*)item1.lParam;
	if (!site)
		return;


	CEditSiteDlg dlg;
	dlg.mSiteName = site->getName();
	dlg.mURL = site->getURL();
	dlg.mRequiresLogin = site->getRegFlag();
	dlg.mUsername = site->getUsername();
	dlg.mPassword = site->getPassword();
	dlg.mSite = site;
	dlg.mAutoLogin = site->getAutoLogin();

	if (dlg.DoModal() == IDOK)
	{
		site->setName( dlg.mSiteName );
		site->setURL( dlg.mURL );
		site->setRegFlag( dlg.mRequiresLogin );
		site->setUsername( dlg.mUsername );
		site->setPassword( dlg.mPassword );
		site->setAutoLogin( dlg.mAutoLogin );
		theApp.mManager.Save();

		//update the text in the list control
		mSiteList.SetItemText( item1.iItem, 0, site->getName() );
		mSiteList.Invalidate();
		mSiteList.UpdateWindow();
	}
	UpdateData(0);

/*	int pos = mSiteList.GetSelectionMark();

	if (pos == -1)
		return;

	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.iItem = (UINT)pos;
	item1.mask = LVIF_PARAM;
	mSiteList.GetItem( &item1 );

	CSite* site = (CSite*)item1.lParam;
	if (!site)
		return;


	CEditSiteDlg dlg;
	dlg.mSiteName = site->getName();
	dlg.mURL = site->getURL();
	dlg.mRequiresLogin = site->getRegFlag();
	dlg.mUsername = site->getUsername();
	dlg.mPassword = site->getPassword();

	if (dlg.DoModal() == IDOK)
	{
		site->setName( dlg.mSiteName );
		site->setURL( dlg.mURL );
		site->setRegFlag( dlg.mRequiresLogin );
		site->setUsername( dlg.mUsername );
		site->setPassword( dlg.mPassword );
		theApp.mManager.Save();

		//update the text in the list control
		mSiteList.SetItemText( item1.iItem, 0, site->getName() );
		mSiteList.Invalidate();
		mSiteList.UpdateWindow();
	}
	UpdateData(0);
*/

}

void CSitesDlg::OnBnClickedAdvanced()
{
	int pos = mSiteList.GetSelectionMark();

	if (pos == -1)
		return;

	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.iItem = (UINT)pos;
	item1.mask = LVIF_PARAM;
	mSiteList.GetItem( &item1 );

	CSite* site = (CSite*)item1.lParam;

	CAdvancedSiteDlg dlg;
	dlg.mFirstName = site->mFormFirstName;
	dlg.mLastName = site->mFormLastName;
	dlg.mFullName = site->mFormFullName;
	dlg.mEmail = site->mFormEmail;
	dlg.mWebsiteTitle = site->mFormWebsiteTitle;
	dlg.mWebsite = site->mFormWebsite;
	dlg.mTitle = site->mFormTitle;
	dlg.mArticle = site->mFormArticle;
	dlg.mCompany = site->mFormCompany;
	dlg.mSubmitter = site->mFormSubmitter;
	dlg.mLogin = site->mFormLogin;
	dlg.mPassword = site->mFormPassword; 
	dlg.mSummary = site->mFormSummary;
	dlg.mBio = site->mFormBio;
	dlg.mLoginSubmit = site->mForm;

	if (dlg.DoModal() == IDOK)
	{
		site->mFormFirstName = dlg.mFirstName;
		site->mFormLastName = dlg.mLastName;
		site->mFormFullName = dlg.mFullName;
		site->mFormEmail = dlg.mEmail;
		site->mFormWebsiteTitle = dlg.mWebsiteTitle;
		site->mFormWebsite = dlg.mWebsite;
		site->mFormTitle = dlg.mTitle;
		site->mFormArticle = dlg.mArticle;
		site->mFormCompany = dlg.mCompany;
		site->mFormSubmitter = dlg.mSubmitter;
		site->mFormLogin = dlg.mLogin;
		site->mFormPassword = dlg.mPassword;
		site->mFormSummary = dlg.mSummary;
		site->mFormBio = dlg.mBio;
		site->mForm = dlg.mLoginSubmit;

		theApp.mManager.Save();
	}
}

void CSitesDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	if (!mSizeInited)
		return;

	int x = 5;
	int y = 5;
	int w = cx - 10;
	int h = cy - 150;

	//resize the site list
	mSiteList.MoveWindow( 5, 5, cx - 10, cy - 50 );

	y = y + h + 5;
	h = (cy - y) - 45;

	int yy = y;

	int infox = x;
	int infoy = y;
	int infow = w;
	int infoh = h;



	//move buttons
	y += h + 5;

	//update
	RECT r1;
	mUpdateButton.GetWindowRect( &r1 );
	w = r1.right - r1.left;
	h = r1.bottom - r1.top;
	mUpdateButton.MoveWindow( x, y, w, h );

	//create
	x += w + 5;
	mCreateButton.MoveWindow( x, y, w, h );

	//delete
	x += w + 5;
	mDeleteButton.MoveWindow( x, y, w, h );

	//submit
	x += w + 5;
	mSelectAllButton.MoveWindow( x, y, w, h );

	//text
	x = 5;
	y += h + 2;
	mInfoLabel.MoveWindow( x, y, 600, h );

	Invalidate();
	UpdateWindow();
}

void CSitesDlg::OnNMDblclkSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{
	*pResult = 0;
	int pos = mSiteList.GetSelectionMark();

	if (pos == -1)
		return;

	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.iItem = (UINT)pos;
	item1.mask = LVIF_PARAM;
	mSiteList.GetItem( &item1 );

	CSite* site = (CSite*)item1.lParam;
	if (!site)
		return;

	ShellExecute(m_hWnd, "open", "iexplore.exe", site->getURL(), "", SW_SHOW);

	CEditSiteDlg dlg;
	dlg.mSiteName = site->getName();
	dlg.mURL = site->getURL();
	dlg.mRequiresLogin = site->getRegFlag();
	dlg.mUsername = site->getUsername();
	dlg.mPassword = site->getPassword();
	dlg.mSite = site;
	dlg.mAutoLogin = site->getAutoLogin();

	if (dlg.DoModal() == IDOK)
	{
		site->setName( dlg.mSiteName );
		site->setURL( dlg.mURL );
		site->setRegFlag( dlg.mRequiresLogin );
		site->setUsername( dlg.mUsername );
		site->setPassword( dlg.mPassword );
		site->setAutoLogin( dlg.mAutoLogin );
		theApp.mManager.Save();

		//update the text in the list control
		mSiteList.SetItemText( item1.iItem, 0, site->getName() );
		mSiteList.Invalidate();
		mSiteList.UpdateWindow();
	}
	UpdateData(0);
}

void CSitesDlg::OnNMKillfocusSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here
	*pResult = 0;
}

void CSitesDlg::OnBnClickedSelectall()
{
	if (!mSelectedAll)
	{
		int nItem = 0;
		for(nItem = 0; nItem < mSiteList.GetItemCount(); nItem++)
		{
			mSiteList.SetCheck( nItem );
		}
		mSelectedAll = 1;
		mSelectAllButton.SetWindowText( "Deselect All" );
	}
	else
	{
		int nItem = 0;
		for(nItem = 0; nItem < mSiteList.GetItemCount(); nItem++)
		{
			mSiteList.SetCheck( nItem, 0);
		}
		mSelectedAll = 0;
		mSelectAllButton.SetWindowText( "Select All" );
	}

}




static int CALLBACK mySiteCompare( LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort )
{
	// lParamSort contains a pointer to the list view control.
	CListCtrl* pListCtrl = (CListCtrl*) lParamSort;

	CSite* site1 = (CSite*)lParam1;
	CSite* site2 = (CSite*)lParam2;

	if (gSortDir == 0)
	{
		return site1->getName().CompareNoCase( site2->getName() );
	}
	else
	{
		return site2->getName().CompareNoCase( site1->getName() );
	}
	return 0;
}

void CSitesDlg::OnLvnColumnclickSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	*pResult = 0;

	int column = pNMLV->iSubItem;
	if (column != 0)
		return;

	if (gSortDir == 0)
		gSortDir = 1;
	else
		gSortDir = 0;
	mSiteList.SortItems( mySiteCompare, (DWORD_PTR)&mSiteList);
	
	*pResult = 0;

}



BOOL CSitesDlg::OnEraseBkgnd(CDC* pDC)
{
	RECT r1;
	mSiteList.GetWindowRect( &r1 );
	ScreenToClient( &r1 );
	pDC->ExcludeClipRect( &r1 );

	return CDialog::OnEraseBkgnd(pDC);
}

void CSitesDlg::OnBnClickedDelete()
{
	int pos = mSiteList.GetSelectionMark();

	if (pos == -1)
		return;

	int id = MessageBox( _T("Are you sure you want to delete this site?"), _T("Delete Site"), MB_YESNO );
	if (id != IDYES)
		return;

	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.iItem = (UINT)pos;
	item1.mask = LVIF_PARAM;
	mSiteList.GetItem( &item1 );

	CSite* site = (CSite*)item1.lParam;
	mSiteList.DeleteItem( pos );

	theApp.mManager.DeleteSite( site );

	//get all checked
	theApp.mManager.mCheckedSites.clear();

	int nItem = 0;
	for(nItem = 0; nItem < mSiteList.GetItemCount(); nItem++)
	{
		BOOL bChecked = mSiteList.GetCheck(nItem);
		if( bChecked == 1 )
		{ 
			CSite* site = (CSite*)mSiteList.GetItemData( nItem );
			theApp.mManager.mCheckedSites.push_back( site );
		}
	}
	theApp.mDialog->mAutoSubmissionDlg.UpdateSites();
}

void CSitesDlg::OnHdnItemdblclickSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMHEADER phdr = reinterpret_cast<LPNMHEADER>(pNMHDR);
	// TODO: Add your control notification handler code here
	// 
	// end
	*pResult = 0;
	int pos = mSiteList.GetSelectionMark();

	if (pos == -1)
		return;

	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.iItem = (UINT)pos;
	item1.mask = LVIF_PARAM;
	mSiteList.GetItem( &item1 );

	CSite* site = (CSite*)item1.lParam;
	if (!site)
		return;
	ShellExecute(m_hWnd, "open", "iexplore.exe", site->getURL(), "", SW_SHOW);
}
