// ArticleSubmitterDlg.h : header file
//

#pragma once
#include "astabctrl.h"
#include "SetupDlg.h"
#include "SitesDlg.h"
#include "ArticlesDlg.h"
#include "AutoSubmissionDlg.h"
#include "ManualSubmissionDlg.h"
#include "afxwin.h"
#include "explorer1.h"

// CArticleSubmitterDlg dialog
class CArticleSubmitterDlg : public CDialog
{
// Construction
public:
	CArticleSubmitterDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_ARTICLESUBMITTER_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	CASTabCtrl mMainTab;

	CSetupDlg mSetupDlg;
	CSitesDlg mSitesDlg;
	CArticlesDlg mArticlesDlg;
	CAutoSubmissionDlg mAutoSubmissionDlg;
	CManualSubmissionDlg mManualSubmissionDlg;
	CImageList mImageList;

	int mSizeInited;
	afx_msg void OnSize(UINT nType, int cx, int cy);

	void sizeControls( int cx, int cy );
	CButton mCloseButton;
	CButton mHelpButton;
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);

	RECT mExcludeRect;
	
	CArticle* mCurArticle;

	void SetCurArticle( CArticle* article )
	{
		mCurArticle = article;
	}

	void StartAuto();

	CExplorer1 mHeader;
	afx_msg void OnGetMinMaxInfo(MINMAXINFO* lpMMI);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
protected:
	virtual void OnOK();
	virtual void OnCancel();
public:
	afx_msg void OnClose();
	afx_msg void OnBnClickedHelp();
	afx_msg void OnAbout();
};
