#include "stdafx.h"
#include "ArticleSubmitter.h"
#include "AutoSubmissionDlg.h"
#include ".\autosubmissiondlg.h"

int gSortDir2 = 0; //0 = ascending, 1 = descending
static int CALLBACK mySiteCompare2( LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort );


// CAutoSubmissionDlg dialog
IMPLEMENT_DYNAMIC(CAutoSubmissionDlg, CDialog)
CAutoSubmissionDlg::CAutoSubmissionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAutoSubmissionDlg::IDD, pParent)
{
	mSizeInited = 0;
}

CAutoSubmissionDlg::~CAutoSubmissionDlg()
{
}

void CAutoSubmissionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EXPLORER1, mBrowser);
	DDX_Control(pDX, IDC_NEXT, mNextButton);
	DDX_Control(pDX, IDC_START, mStartButton);
	DDX_Control(pDX, IDC_SITELIST, mSiteList);
}


BEGIN_MESSAGE_MAP(CAutoSubmissionDlg, CDialog)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_START, OnBnClickedStart)
	ON_BN_CLICKED(IDC_NEXT, OnBnClickedNext)
	ON_WM_SETFOCUS()
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_SITELIST, OnLvnColumnclickSitelist)
	ON_NOTIFY(NM_KILLFOCUS, IDC_SITELIST, OnNMKillfocusSitelist)
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()


// CAutoSubmissionDlg message handlers

BOOL CAutoSubmissionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	mBrowser.HookEvents();
	mBrowser.Navigate( _T("about:blank"), 0, 0, 0, 0 );

	mSizeInited = 1;


	mSiteList.SetExtendedStyle( mSiteList.GetExtendedStyle() | LVS_EX_FULLROWSELECT);
	mSiteList.EnableToolTips(TRUE);


	RECT r;
	mSiteList.GetClientRect( &r );
	mSiteList.InsertColumn( 0, _T("Websites"), LVCFMT_LEFT, 200 );

/*	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.mask = LVIF_IMAGE|LVIF_PARAM;
	item1.lParam = (DWORD)(*i);
	item1.iImage = 0;
	item1.iItem = 0;
	mSiteList.InsertItem( &item1 );
*/


	return TRUE;
}

void CAutoSubmissionDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	if (mSizeInited)
	{
		int x = 5;
		RECT r;
		mStartButton.GetWindowRect( &r );
		int w = r.right - r.left;
		int h = r.bottom - r.top;
		int y = (cy - h)-5;
		mStartButton.MoveWindow( x, y, w, h );

		x = (cx - w) - 5;
		mNextButton.MoveWindow( x, y, w, h );

		mBrowser.MoveWindow( 5, 5, cx - 150, y - 10);
		mSiteList.MoveWindow( (cx-150)+5, 5, cx - ((cx-150)+5), y - 10 );
	}
}

void CAutoSubmissionDlg::StartAuto()
{
	mCurIndex = 0;
	if (theApp.mManager.mCheckedSites.size() == 0)
		return;
	if (theApp.mManager.mArticles.size() == 0)
		return;

	CSite* site = theApp.mManager.mCheckedSites[mCurIndex++];
	if (!site)
		return;

	mBrowser.mSite = site;
	mBrowser.mArticle = theApp.mManager.mArticles[0];
	mBrowser.Navigate( site->getURL(), 0, 0, 0, 0 );

	UpdateGUI();
}

void CAutoSubmissionDlg::UpdateGUI()
{
	//	mSiteList.SetSelectionMark( 0 );
	mSiteList.SetFocus();
	int nItem = 0;
	for(nItem = 0; nItem < mSiteList.GetItemCount(); nItem++)
	{
		if (nItem == mCurIndex-1)
		{
			mSiteList.SetSelectionMark( nItem );
			mSiteList.EnsureVisible( nItem, 0 );
			mSiteList.SetItemState( nItem, LVIS_FOCUSED | LVIS_SELECTED, LVIS_SELECTED|LVIS_FOCUSED );

		}
		else
		{
//			mSiteList.EnsureVisible( nItem, 0 );
			mSiteList.SetItemState( nItem, 0, LVIS_SELECTED|LVIS_FOCUSED );
		}
	}
	mSiteList.Invalidate();
	mSiteList.UpdateWindow();
	RECT r;
	GetWindowRect( &r );
	GetParent()->ScreenToClient( &r );

	MoveWindow( r.left, r.top, r.right - r.left, r.bottom - r.top );
}


void CAutoSubmissionDlg::OnBnClickedStart()
{
	theApp.StartAuto();
}

void CAutoSubmissionDlg::OnBnClickedNext()
{
	if (mCurIndex >= (int)theApp.mManager.mCheckedSites.size())
		return;

	CSite* site = theApp.mManager.mCheckedSites[mCurIndex++];
	mBrowser.mSite = site;
	mBrowser.mArticle = theApp.mManager.mArticles[0];
	mBrowser.Navigate( site->getURL(), 0, 0, 0, 0 );

	UpdateGUI();
}

void CAutoSubmissionDlg::OnSetFocus(CWnd* pOldWnd)
{
	CDialog::OnSetFocus(pOldWnd);
}

void CAutoSubmissionDlg::UpdateSites()
{
	if (!mSizeInited)
		return;

	mSiteList.DeleteAllItems();

	std::vector<CSite*>& sites = theApp.mManager.mCheckedSites;

	for (std::vector<CSite*>::iterator i = sites.begin();
			i < sites.end(); i++)
	{
		LVITEM item1;
		ZeroMemory( &item1, sizeof( LVITEM ) );
		item1.mask = LVIF_IMAGE|LVIF_PARAM;
		item1.lParam = (DWORD)(*i);
		item1.iImage = 0;
		item1.iItem = 0;
		item1.pszText = (LPSTR)(LPCTSTR)(*i)->getName();
		int id = mSiteList.InsertItem( &item1 );
		mSiteList.SetItemText( id, 0, (*i)->getName() );
	}
	mSiteList.SortItems( mySiteCompare2, (DWORD_PTR)&mSiteList);
}




static int CALLBACK mySiteCompare2( LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort )
{
	// lParamSort contains a pointer to the list view control.
	CListCtrl* pListCtrl = (CListCtrl*) lParamSort;

	CSite* site1 = (CSite*)lParam1;
	CSite* site2 = (CSite*)lParam2;

	if (gSortDir2 == 0)
	{
		return site1->getName().CompareNoCase( site2->getName() );
	}
	else
	{
		return site2->getName().CompareNoCase( site1->getName() );
	}
	return 0;
}

void CAutoSubmissionDlg::OnLvnColumnclickSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{
	return;

	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	*pResult = 0;

	int column = pNMLV->iSubItem;
	if (column != 0)
		return;

	if (gSortDir2 == 0)
		gSortDir2 = 1;
	else
		gSortDir2 = 0;
	mSiteList.SortItems( mySiteCompare2, (DWORD_PTR)&mSiteList);
	
	*pResult = 0;
}

void CAutoSubmissionDlg::OnNMKillfocusSitelist(NMHDR *pNMHDR, LRESULT *pResult)
{
	return;
	// TODO: Add your control notification handler code here
	*pResult = 0;
}

BOOL CAutoSubmissionDlg::OnEraseBkgnd(CDC* pDC)
{
	RECT r1;
	mBrowser.GetWindowRect( &r1 );
	ScreenToClient( &r1 );
	pDC->ExcludeClipRect( &r1 );

	mSiteList.GetWindowRect( &r1 );
	ScreenToClient( &r1 );
	pDC->ExcludeClipRect( &r1 );

	return CDialog::OnEraseBkgnd(pDC);
}
