// EditArticleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ArticleSubmitter.h"
#include "EditArticleDlg.h"
#include ".\editarticledlg.h"


// CEditArticleDlg dialog

IMPLEMENT_DYNAMIC(CEditArticleDlg, CDialog)
CEditArticleDlg::CEditArticleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEditArticleDlg::IDD, pParent)
	, mTitle(_T(""))
	, mText(_T(""))
	, mSummary(_T(""))
	, mKeywords(_T(""))
{
	mSizeInited = 0;
	mCurArticle = 0;
}

CEditArticleDlg::~CEditArticleDlg()
{
}

void CEditArticleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_TITLE, mTitle);
	DDX_Text(pDX, IDC_ARTICLETEXT, mText);
	DDX_Control(pDX, IDC_TITLEGROUP, mTitleGroup);
	DDX_Control(pDX, IDC_TITLE, mTitleEdit);
	DDX_Control(pDX, IDC_TEXTGROUP, mTextGroup);
	DDX_Control(pDX, IDC_ARTICLETEXT, mTextEdit);
	DDX_Control(pDX, IDOK, mApplyButton);
	DDX_Control(pDX, IDC_SUMMARYGROUP, mSummaryGroup);
	DDX_Control(pDX, IDC_SUMMARY, mSummaryEdit);
	DDX_Text(pDX, IDC_SUMMARY, mSummary);
	DDX_Text(pDX, IDC_KEYWORDS2, mKeywords);
}


BEGIN_MESSAGE_MAP(CEditArticleDlg, CDialog)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()


// CEditArticleDlg message handlers

BOOL CEditArticleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	mSizeInited = 1;
	return TRUE;  
}

void CEditArticleDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	if (!mSizeInited)
		return;

	int x = 5;
	int y = 5;
	int w = cx - 10;
	int ww = w ;
	int h = 45;

	mTitleGroup.MoveWindow( x, y, w, h );

	mTitleEdit.MoveWindow( 10, 20, w - 10, 20 );

	y += h + 5;
	h = (cy - y) - 130;
	mTextGroup.MoveWindow( x, y, w, h);
	mTextEdit.MoveWindow( x + 5, y + 20, w - 10, h - 25);




	//buttons
	RECT r1;
	mApplyButton.GetWindowRect( &r1 );
	h = r1.bottom - r1.top;
	w = r1.right - r1.left;
	y = (cy - h) - 5;
	mApplyButton.MoveWindow( x, y, w, h );

//	x += w + 5;
//	mNewArtButton.MoveWindow( x, y, w, h );

	//summary
	x = 5;
	y -= 100;
	h = 100;
	w = ww;
	mSummaryGroup.MoveWindow( x, y, w, h );
	mSummaryEdit.MoveWindow( x + 5, y + 20, w - 10, h - 25);

	Invalidate();
}


void CEditArticleDlg::Update()
{
	static int firsttime = 0;

	if (!mCurArticle)
		return;

	mTitle = mCurArticle->getTitle();
	mText = mCurArticle->getText();
	mSummary = mCurArticle->getSummary();
	if (mSizeInited)
	{
		UpdateData(0);
	}
}


void CEditArticleDlg::OnBnClickedOk()
{
	UpdateData(1);

	mCurArticle->setTitle( mTitle );
	mCurArticle->setText( mText );
	mCurArticle->setSummary( mSummary );
	theApp.mManager.Save();
}

BOOL CEditArticleDlg::OnEraseBkgnd(CDC* pDC)
{
	RECT r1;
	mTitleEdit.GetWindowRect( &r1 );
	ScreenToClient( &r1 );
	pDC->ExcludeClipRect( &r1 );

	mTextEdit.GetWindowRect( &r1 );
	ScreenToClient( &r1 );
	pDC->ExcludeClipRect( &r1 );

	mSummaryEdit.GetWindowRect( &r1 );
	ScreenToClient( &r1 );
	pDC->ExcludeClipRect( &r1 );


	return CDialog::OnEraseBkgnd(pDC);
}

void CEditArticleDlg::OnBnClickedNewArticle()
{
	UpdateData( 1 );

	CArticle* art = new CArticle();
	art->setTitle( mTitle );
	art->setText( mText );
	art->setSummary( mSummary );
	theApp.mManager.addArticle( art );
	theApp.mManager.Save();

	//add to the list view
	LVITEM item1;
	ZeroMemory( &item1, sizeof( LVITEM ) );
	item1.mask = LVIF_IMAGE|LVIF_PARAM;
	item1.lParam = (DWORD)art;
	item1.iImage = 0;
	item1.iItem = 0;
	int id = theApp.mDialog->mArticlesDlg.mArticleList.InsertItem( &item1 );
	theApp.mDialog->mArticlesDlg.mArticleList.SetItemText( id, 0, mTitle );
}
