// ManualSubmissionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ArticleSubmitter.h"
#include "ManualSubmissionDlg.h"
#include "AddSiteDlg.h"


// CManualSubmissionDlg dialog

IMPLEMENT_DYNAMIC(CManualSubmissionDlg, CDialog)
CManualSubmissionDlg::CManualSubmissionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CManualSubmissionDlg::IDD, pParent)
{
	mSizeInited = 0;
	mCurSite = 0;
}

CManualSubmissionDlg::~CManualSubmissionDlg()
{
}

void CManualSubmissionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SITECOMBO, mSiteCombo);
	DDX_Control(pDX, IDC_EXPLORER1, mBrowser);
	DDX_Control(pDX, IDC_CHOOSESITESTATIC, mChooseSiteStatic);
	DDX_Control(pDX, IDC_FILL, mFillButton);
	DDX_Control(pDX, IDC_ADDSITE, mAddSiteButton);
}


BEGIN_MESSAGE_MAP(CManualSubmissionDlg, CDialog)
	ON_WM_SIZE()
	ON_CBN_SELCHANGE(IDC_SITECOMBO, OnCbnSelchangeSitecombo)
	ON_BN_CLICKED(IDC_FILL, OnBnClickedFill)
	ON_BN_CLICKED(IDC_ADDSITE, OnBnClickedAddsite)
END_MESSAGE_MAP()


// CManualSubmissionDlg message handlers


BOOL CManualSubmissionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	//add the combo box entires
	mBrowser.HookEvents();
	mBrowser.Navigate( _T("about:blank"), 0, 0, 0, 0 );
	mSizeInited = 1;
	return TRUE;
}


void CManualSubmissionDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);
	if (mSizeInited)
	{
		mBrowser.MoveWindow( 5, 30, cx - 10, cy - 60 );

		RECT r2;
		mFillButton.GetWindowRect( &r2 );
		int ww = r2.right - r2.left;
		int hh = r2.bottom - r2.top;
		mFillButton.MoveWindow( 5, cy - 30, ww, hh );

		mAddSiteButton.MoveWindow( 5 + ww + 5, cy - 30, ww, hh );


		RECT r1;
		mChooseSiteStatic.GetWindowRect( &r1 );
		int w = r1.right - r1.left;
		int h = r1.bottom - r1.top;
		mChooseSiteStatic.MoveWindow( 5, 8, w, h );

		int x = w + 10;
		mSiteCombo.MoveWindow( x, 5, 250, 20 );
	}
}

void CManualSubmissionDlg::OnCbnSelchangeSitecombo()
{
	int sel = mSiteCombo.GetCurSel();
	CManualSite* site = (CManualSite*)mSiteCombo.GetItemData( sel );
	if (site)
	{
//		mBrowser.mSite = site;
		mCurSite = site;
		mBrowser.mArticle = theApp.mCurArticle;
		mBrowser.Navigate( site->mURL, 0, 0, 0, 0 );
	}
}

void CManualSubmissionDlg::OnBnClickedFill()
{
	if (!mCurSite)
		return;

	//find current article
	CArticle* article = theApp.mCurArticle;
	if (!article)
		return;

	mBrowser.mArticle = article;

	mBrowser.FillManual( mCurSite, article );
}

void CManualSubmissionDlg::OnBnClickedAddsite()
{
	CAddSiteDlg dlg;
	if (dlg.DoModal() == IDOK)
	{
		CManualSite* site = new CManualSite();
		site->mTitle = dlg.mTitle;
		site->mURL = dlg.mURL;
		theApp.mManager.mManualSites.push_back( site );
		theApp.mManager.Save();

		int id = mSiteCombo.AddString( site->mTitle );
		mSiteCombo.SetItemData( id, (DWORD_PTR)site );
	}
}
